/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.appbridge.software;

import com.atlassian.extras.common.LicenseException;
import com.atlassian.fugue.Option;
import com.atlassian.greenhopper.api.rapid.configuration.LabsConfigurationService;
import com.atlassian.greenhopper.api.rapid.view.QuickFilter;
import com.atlassian.greenhopper.api.rapid.view.RapidViewCreationService;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugins.importer.appbridge.software.GreenHopperBridgeUtils;
import com.atlassian.jira.plugins.importer.appbridge.software.JimJiraSoftwareAccessor;
import com.atlassian.jira.plugins.importer.imports.pivotal.RapidBoardColumnsMapping;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.order.SortOrder;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.pyxis.greenhopper.jira.license.GreenHopperLicenseManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class JimJiraSoftwareAccessorImpl
implements JimJiraSoftwareAccessor {
    private static final Logger log = Logger.getLogger(JimJiraSoftwareAccessorImpl.class);
    private final SearchRequestService searchRequestService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ConstantsManager constantsManager;
    private final PluginAccessor pluginAccessor;
    private final GreenHopperBridgeUtils bridgeUtils;

    @Autowired
    public JimJiraSoftwareAccessorImpl(@ComponentImport SearchRequestService searchRequestService, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport ConstantsManager constantsManager, @ComponentImport PluginAccessor pluginAccessor) {
        this.searchRequestService = searchRequestService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.constantsManager = constantsManager;
        this.pluginAccessor = pluginAccessor;
        this.bridgeUtils = new GreenHopperBridgeUtils(pluginAccessor);
    }

    @Override
    public boolean isGreenHopperInstalledAndEnabled() {
        Plugin plugin = this.pluginAccessor.getPlugin("com.pyxis.greenhopper.jira");
        return plugin != null && plugin.getPluginState().equals((Object)PluginState.ENABLED);
    }

    @Override
    public boolean isGreenHooperFeaturesEnabled() {
        if (!this.isGreenHopperInstalledAndEnabled()) {
            return false;
        }
        try {
            GreenHopperLicenseManager licenseManager = (GreenHopperLicenseManager)ComponentAccessor.getOSGiComponentInstanceOfType(GreenHopperLicenseManager.class);
            if (licenseManager != null) {
                licenseManager.verify();
                return true;
            }
        }
        catch (NoClassDefFoundError e) {
            log.error((Object)"GreenHopper plugin is enabled but GreenHopperLicenseManager could not be found!", (Throwable)e);
        }
        catch (LicenseException e) {
            log.error((Object)"GreenHopper plugin is enabled or it's license is invalid", (Throwable)e);
        }
        return false;
    }

    @Override
    @Nullable
    public Pair<Long, String> createRapidBoard(Project project) throws Exception {
        RapidViewCreationService rapidViewCreationService = (RapidViewCreationService)ComponentAccessor.getOSGiComponentInstanceOfType(RapidViewCreationService.class);
        LabsConfigurationService labsConfigurationService = (LabsConfigurationService)ComponentAccessor.getOSGiComponentInstanceOfType(LabsConfigurationService.class);
        if (rapidViewCreationService == null || labsConfigurationService == null) {
            log.debug((Object)"Cannot fetch JIRA Agile components");
            return null;
        }
        if (!labsConfigurationService.isRapidBoardEnabled()) {
            labsConfigurationService.setRapidBoardEnabled(true);
        }
        JiraServiceContextImpl context = new JiraServiceContextImpl(this.jiraAuthenticationContext.getUser());
        SearchRequest filter = new SearchRequest();
        String rapidBoardName = String.format("%s Rapid Board", project.getKey());
        filter.setName(rapidBoardName);
        filter.setQuery(JqlQueryBuilder.newBuilder().where().project(new String[]{project.getKey()}).and().sub().fixVersionIsEmpty().or().fixVersion().inFunc("unreleasedVersions").endsub().endWhere().orderBy().addSortForFieldName(this.jiraAuthenticationContext.getI18nHelper().getText("gh.rank.global.name"), SortOrder.ASC, true).buildQuery());
        filter.setPermissions(SharedEntity.SharePermissions.GLOBAL);
        filter.setOwnerUserName(context.getLoggedInApplicationUser().getName());
        filter = this.searchRequestService.createFilter((JiraServiceContext)context, filter);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Long viewId = rapidViewCreationService.createNewRapidView(context.getLoggedInApplicationUser().getDirectoryUser(), rapidBoardName, filter.getId().longValue(), (ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            throw new Exception(errors.toString());
        }
        rapidViewCreationService.setStatusMappings(context.getLoggedInApplicationUser().getDirectoryUser(), viewId.longValue(), RapidBoardColumnsMapping.getRapidBoardColumns(this.constantsManager), (ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            throw new Exception(errors.toString());
        }
        rapidViewCreationService.setSwimlanes(context.getLoggedInApplicationUser().getDirectoryUser(), viewId.longValue(), (List)Lists.newArrayList(), (ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            throw new Exception(errors.toString());
        }
        ArrayList quickFilters = Lists.newArrayList((Object[])new QuickFilter[]{new QuickFilter("Only My Issues", "assignee = currentUser()"), new QuickFilter("Recently Updated", "updatedDate >= -1d")});
        rapidViewCreationService.setQuickFilters(context.getLoggedInApplicationUser().getDirectoryUser(), viewId.longValue(), (List)quickFilters, (ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            throw new Exception(errors.toString());
        }
        return Pair.of((Object)viewId, (Object)project.getName());
    }

    @Override
    public Option<Long> reuseOrCreateSprint(DateTime completeDateTime, DateTime startDate, DateTime endDate, String name, String state, Long rapidViewId, Project project) {
        Sprint.State sprintState = Sprint.State.CLOSED.toString().equalsIgnoreCase(state) ? Sprint.State.CLOSED : (Sprint.State.ACTIVE.toString().equalsIgnoreCase(state) ? Sprint.State.ACTIVE : Sprint.State.FUTURE);
        final Sprint sprint = Sprint.builder().completeDate(completeDateTime).startDate(startDate).endDate(endDate).name(name).state(sprintState).rapidViewId(rapidViewId == null ? this.getRapidBoardIdForProject(project) : rapidViewId).build();
        return this.bridgeUtils.findSprint(sprint).orElse((Supplier)new Supplier<Option<Long>>(){

            public Option<Long> get() {
                return JimJiraSoftwareAccessorImpl.this.bridgeUtils.createSprint(sprint);
            }
        });
    }

    private Long getRapidBoardIdForProject(Project project) {
        List<RapidView> availableRapidBoards = this.bridgeUtils.getRapidViewsForCurrentUser();
        String boardName = this.jiraAuthenticationContext.getI18nHelper().getText("gh.board.name", project.getKey());
        RapidView matchingRapidView = null;
        for (RapidView rapidView : availableRapidBoards) {
            if (!boardName.equals(rapidView.getName())) continue;
            matchingRapidView = matchingRapidView == null || rapidView.getId() > matchingRapidView.getId() ? rapidView : matchingRapidView;
        }
        return matchingRapidView != null ? matchingRapidView.getId() : null;
    }

    @Override
    public String getStoryPointsCustomFieldName() {
        return this.bridgeUtils.getStoryPointsCustomFieldName();
    }

    @Override
    public String getEpicIssueType() {
        return this.bridgeUtils.getEpicIssueType();
    }

    @Override
    public String getStoryIssueType() {
        return this.bridgeUtils.getStoryIssueType();
    }

    @Override
    public Option<CustomField> getStoryPointsCustomField() {
        return this.bridgeUtils.getStoryPointsCustomField();
    }

    @Override
    public Option<Long> getSprintIdByName(String name, Project project) {
        Long rapidViewId = (Long)Preconditions.checkNotNull((Object)this.getRapidBoardIdForProject(project), (String)"Couldn't find board for project with key=%s and id=%s", (Object[])new Object[]{project.getKey(), project.getId()});
        Sprint sprintRequest = Sprint.builder().rapidViewId(rapidViewId).name(name).state(null).build();
        return this.bridgeUtils.findSprint(sprintRequest);
    }
}

