/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.appbridge.software;

import com.atlassian.fugue.Option;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.VersionKit;
import com.atlassian.jira.plugins.importer.compatibility.EmptyJiraSoftwareUtil;
import com.atlassian.jira.plugins.importer.compatibility.JiraSoftware67;
import com.atlassian.jira.plugins.importer.compatibility.JiraSoftwarePre67;
import com.atlassian.jira.plugins.importer.compatibility.JiraSoftwareUtil;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;

public class GreenHopperBridgeUtils {
    private final VersionKit.SoftwareVersion GH_6_7_10 = VersionKit.version(6, 7, 10);
    private final PluginAccessor pluginAccessor;

    public GreenHopperBridgeUtils(@ComponentImport PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public List<RapidView> getRapidViewsForCurrentUser() {
        return this.getUtil().getRapidViewsForCurrentUser();
    }

    public Option<Long> createSprint(Sprint sprint) {
        return this.getUtil().createSprint(sprint);
    }

    public Option<Long> findSprint(Sprint sprint) {
        return this.getUtil().findSprint(sprint);
    }

    private JiraSoftwareUtil getUtil() {
        Plugin ghPlugin = this.pluginAccessor.getPlugin("com.pyxis.greenhopper.jira");
        if (ghPlugin != null && ghPlugin.getPluginState() == PluginState.ENABLED) {
            VersionKit.SoftwareVersion ghVersion = VersionKit.parse(ghPlugin.getPluginInformation().getVersion());
            if (ghVersion.isLessThan(this.GH_6_7_10)) {
                return new JiraSoftwarePre67();
            }
            return new JiraSoftware67();
        }
        return new EmptyJiraSoftwareUtil();
    }

    public String getStoryPointsCustomFieldName() {
        return this.getUtil().getStoryPointsCustomFieldName();
    }

    public Option<CustomField> getStoryPointsCustomField() {
        return this.getUtil().getStoryPointsCustomField();
    }

    public String getEpicIssueType() {
        return this.getUtil().getEpicIssueType();
    }

    public String getStoryIssueType() {
        return this.getUtil().getStoryIssueType();
    }
}

