/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.analytics;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.plugins.importer.analytics.DemoDataImportFinishedEvent;
import com.atlassian.jira.plugins.importer.analytics.DemoDataImportFinishedEventFactory;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.compatibility.DemoProjectsAccessor;
import com.atlassian.jira.plugins.importer.rest.DemoDataResponse;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;

public class DemoDataImportFinishedEventFactoryImpl
implements DemoDataImportFinishedEventFactory {
    private JiraAuthenticationContext authenticationContext;
    private ProjectManager projectManager;
    private ProjectService projectService;
    private CompatibilityBridgeUtils compatibilityUtil;

    public DemoDataImportFinishedEventFactoryImpl(JiraAuthenticationContext authenticationContext, ProjectManager projectManager, ProjectService projectService, CompatibilityBridgeUtils compatibilityUtil) {
        this.authenticationContext = authenticationContext;
        this.projectManager = projectManager;
        this.projectService = projectService;
        this.compatibilityUtil = compatibilityUtil;
    }

    @Override
    public DemoDataImportFinishedEvent getDemoDataImportFinishedEvent(String demoDataKey, DemoProjectsAccessor.DemoProject demoProject, DemoDataResponse demoDataResponse) {
        boolean evalInstance = false;
        int existingProjectNum = -1;
        int existingProjectNumUserAccess = -1;
        if (demoProject.getProjectType().isDefined()) {
            final String projectTypeString = (String)demoProject.getProjectType().get();
            int num = Iterables.size((Iterable)Iterables.filter((Iterable)this.projectManager.getProjectObjects(), (Predicate)new Predicate<Project>(){

                public boolean apply(@Nullable Project project) {
                    return projectTypeString.equals(DemoDataImportFinishedEventFactoryImpl.this.compatibilityUtil.getProjectTypeKey(project));
                }
            }));
            existingProjectNum = num - 1;
            ServiceOutcome projectsUserAccess = this.projectService.getAllProjects(this.authenticationContext.getUser());
            if (projectsUserAccess.isValid()) {
                int userAccessNum;
                final String createdProjectKey = demoDataResponse.getProjectKey();
                boolean hasAccessToCreatedProject = Iterables.size((Iterable)Iterables.filter((Iterable)((Iterable)projectsUserAccess.getReturnedValue()), (Predicate)new Predicate<Project>(){

                    public boolean apply(@Nullable Project project) {
                        return project.getKey().equals(createdProjectKey);
                    }
                })) > 0;
                existingProjectNumUserAccess = userAccessNum = Iterables.size((Iterable)Iterables.filter((Iterable)((Iterable)projectsUserAccess.getReturnedValue()), (Predicate)new Predicate<Project>(){

                    public boolean apply(@Nullable Project project) {
                        return projectTypeString.equals(DemoDataImportFinishedEventFactoryImpl.this.compatibilityUtil.getProjectTypeKey(project));
                    }
                }));
                if (hasAccessToCreatedProject) {
                    --existingProjectNumUserAccess;
                }
            }
            evalInstance = (Boolean)demoProject.getProjectType().map((Function)new Function<String, Boolean>(){

                public Boolean apply(@Nullable String projectType) {
                    return DemoDataImportFinishedEventFactoryImpl.this.compatibilityUtil.isProductEvaluationLicenseForProjectType(projectType);
                }
            }).getOrElse((Object)false);
        }
        String userCreatedDateString = "";
        ApplicationUser auser = this.authenticationContext.getUser();
        if (auser != null) {
            Option<Date> userCreatedDateOption = this.compatibilityUtil.getUserCreatedDate(auser);
            userCreatedDateString = (String)userCreatedDateOption.map(this.getDateToStringFunction()).getOrElse((Object)"");
        }
        Option<Date> instanceCreatedDateOption = this.compatibilityUtil.getInstanceCreatedDate();
        String instanceCreatedDateString = (String)instanceCreatedDateOption.map(this.getDateToStringFunction()).getOrElse((Object)"");
        return new DemoDataImportFinishedEvent(demoDataKey, evalInstance, existingProjectNum, existingProjectNumUserAccess, userCreatedDateString, instanceCreatedDateString);
    }

    private Function<Date, String> getDateToStringFunction() {
        final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return new Function<Date, String>(){

            public String apply(@Nullable Date input) {
                return sdf.format(input);
            }
        };
    }
}

