/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer;

import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class BackCompatibilityUtil {
    private static final Map<String, String> databaseTypeMap = MapBuilder.newBuilder().add((Object)"postgres72", (Object)"POSTGRES").add((Object)"mysql", (Object)"MY_SQL").add((Object)"mssql", (Object)"SQL_SERVER").toMap();
    private Optional<Method> getJiraLicenseMethod;
    private Optional<Method> removeTaskMethod;
    private Class<?> databaseConfigFactory;
    private Class<?> databaseType;

    public BackCompatibilityUtil() {
        this.prepareLicenseMethod();
        this.prepareDatabaseClasses();
    }

    private void prepareDatabaseClasses() {
        try {
            this.databaseConfigFactory = this.getClass().getClassLoader().loadClass("com.atlassian.jira.configurator.db.DatabaseConfigFactory");
            this.databaseType = this.getClass().getClassLoader().loadClass("com.atlassian.jira.configurator.config.DatabaseType");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (this.databaseConfigFactory == null) {
            try {
                this.databaseType = this.getClass().getClassLoader().loadClass("com.atlassian.jira.config.database.DatabaseType");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot find database/JDBC releated classes");
            }
        }
    }

    private Object findDatabaseMysqlType(String enumName) {
        for (Object enumValue : this.databaseType.getEnumConstants()) {
            if (!enumName.equals(((Enum)enumValue).name())) continue;
            return enumValue;
        }
        throw new RuntimeException(String.format("Cannot find enum value %s in class %s", enumName, this.databaseType));
    }

    private void prepareLicenseMethod() {
        try {
            this.getJiraLicenseMethod = Optional.of((Object)LicenseDetails.class.getMethod("getJiraLicense", new Class[0]));
        }
        catch (NoSuchMethodException ignore) {
            this.getJiraLicenseMethod = Optional.absent();
        }
        try {
            this.removeTaskMethod = Optional.of((Object)TaskManager.class.getMethod("removeTask", Long.class));
        }
        catch (NoSuchMethodException e) {
            this.removeTaskMethod = Optional.absent();
        }
    }

    public Optional<String> getJiraLicenseProperty(LicenseDetails licenseDetails, String propertyName) {
        if (!this.getJiraLicenseMethod.isPresent()) {
            return Optional.absent();
        }
        try {
            Method getJiraLicense = (Method)this.getJiraLicenseMethod.get();
            Object jiraLicenseObject = getJiraLicense.invoke((Object)licenseDetails, new Object[0]);
            Method getPropertyMethod = jiraLicenseObject.getClass().getMethod("getProperty", String.class);
            String propertyValue = (String)getPropertyMethod.invoke(jiraLicenseObject, propertyName);
            return Optional.fromNullable((Object)propertyValue);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return Optional.absent();
    }

    public void removeTask(TaskManager taskManager, Long id) {
        if (!this.removeTaskMethod.isPresent()) {
            return;
        }
        Method removeTask = (Method)this.removeTaskMethod.get();
        try {
            removeTask.invoke((Object)taskManager, id);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private boolean isNewJira63() {
        return this.databaseConfigFactory == null;
    }

    public String getDriverClassName(String dbName) {
        String enumName = (String)Preconditions.checkNotNull((Object)databaseTypeMap.get(dbName), (Object)"Cannot find this driver");
        try {
            if (this.isNewJira63()) {
                return (String)this.databaseType.getMethod("getJdbcDriverClassName", new Class[0]).invoke(this.findDatabaseMysqlType(enumName), new Object[0]);
            }
            Object databaseConfig = this.getDatabaseConfig(enumName);
            return (String)databaseConfig.getClass().getMethod("getClassName", new Class[0]).invoke(databaseConfig, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Object getDatabaseConfig(String enumName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.databaseConfigFactory.getMethod("getDatabaseConfigFor", this.databaseType).invoke(null, this.findDatabaseMysqlType(enumName));
    }

    public String getDatabaseUrl(String dbName, String jdbcHostname, String jdbcPort, String jdbcDatabase) {
        String enumName = (String)Preconditions.checkNotNull((Object)databaseTypeMap.get(dbName), (Object)"Cannot find this driver");
        try {
            Object urlParser = this.isNewJira63() ? this.databaseType.getMethod("getJdbcUrlParser", new Class[0]).invoke(this.findDatabaseMysqlType(enumName), new Object[0]) : this.getDatabaseConfig(enumName);
            return (String)urlParser.getClass().getMethod("getUrl", String.class, String.class, String.class).invoke(urlParser, jdbcHostname, jdbcPort, jdbcDatabase);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

