/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer;

import com.atlassian.jira.plugins.importer.LimitInputStream;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.web.util.AttachmentException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.springframework.stereotype.Component;
import webwork.config.Configuration;

@Component
public class AttachmentHelper {
    public static final Result OK = new Result("", true);

    public Result isValidTemporaryAttachmentDirectory() {
        try {
            AttachmentUtils.checkValidTemporaryAttachmentDirectory();
        }
        catch (AttachmentException e) {
            return new Result(e.getMessage());
        }
        return OK;
    }

    public UniqueFile getTemporaryUniqueFile(String filename) {
        File temporaryAttachmentDirectory = AttachmentUtils.getTemporaryAttachmentDirectory();
        long uniqueId = this.getUUID();
        File tempFile = new File(temporaryAttachmentDirectory, uniqueId + "_" + this.sanitise(filename));
        return new UniqueFile(tempFile, uniqueId);
    }

    private String sanitise(String filename) {
        if (filename == null) {
            return null;
        }
        return new File(filename).getName();
    }

    public Long getMaxAttachmentSize() {
        return new Long(Configuration.getString((String)"webwork.multipart.maxSize"));
    }

    public void copyFile(File output, File input) throws IOException {
        FileInputStream inputStream = new FileInputStream(input);
        long length = input.length();
        this.copyFile(length, output, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(long size, File tempFile, InputStream requestInputStream) throws IOException {
        FileOutputStream output = null;
        try {
            LimitInputStream inputStream = new LimitInputStream(requestInputStream, size);
            output = new FileOutputStream(tempFile);
            IOUtil.copy((InputStream)inputStream, (OutputStream)output);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    private long getUUID() {
        return Math.abs(UUID.randomUUID().getLeastSignificantBits());
    }

    public static class UniqueFile {
        private final File file;
        private final long id;

        public UniqueFile(File file, long id) {
            this.file = file;
            this.id = id;
        }

        public File getFile() {
            return this.file;
        }

        public long getId() {
            return this.id;
        }
    }

    public static class Result {
        public final String message;
        public final boolean valid;

        private Result(String message, boolean valid) {
            this.message = message;
            this.valid = valid;
        }

        public Result(String message) {
            this.valid = false;
            this.message = message;
        }
    }
}

