/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.importer.github.fetch.RemoteCall;
import com.atlassian.jira.util.I18nHelper;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.egit.github.core.client.NoSuchPageException;
import org.eclipse.egit.github.core.client.RequestException;

public class GithubRequestService {
    private final Logger log = Logger.getLogger(this.getClass());
    private final I18nHelper i18n = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    private final FailureCallback failureCallback;
    private final int maxAttempts;
    private final Long retryFeedbackInterval;

    public GithubRequestService(FailureCallback failureCallback) {
        this(failureCallback, 100, 1000L);
    }

    public GithubRequestService(FailureCallback failureCallback, int maxAttempts, Long retryFeedbackInterval) {
        this.failureCallback = failureCallback;
        this.maxAttempts = maxAttempts;
        this.retryFeedbackInterval = retryFeedbackInterval;
    }

    public <T> T submit(RemoteCall<T> callable) throws IOException, InterruptedException {
        int attempt = 0;
        while (true) {
            ++attempt;
            try {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                T obj = callable.call();
                if (attempt > 1) {
                    this.failureCallback.retriesFinished();
                }
                return obj;
            }
            catch (RequestException e) {
                if (this.isRateLimitError(e)) {
                    long delayMillis = TimeUnit.MINUTES.toMillis(10L);
                    this.sleep(delayMillis, this.i18n.getText("com.atlassian.jira.plugins.importer.github.fetchData.warning.rateLimit"));
                    continue;
                }
                throw e;
            }
            catch (IOException e) {
                this.handleNetworkingException(e, attempt);
                continue;
            }
            catch (NoSuchPageException e) {
                if (e.getCause() instanceof IOException) {
                    IOException wrapper = new IOException("Wrapper for a NoSuchPageException which is actually an IOException", e);
                    this.handleNetworkingException(wrapper, attempt);
                    continue;
                }
                throw new RuntimeException("Unexpected NoSuchPageException", e);
            }
            break;
        }
    }

    private boolean isRateLimitError(RequestException e) {
        return e.getStatus() == 403 && e.getError().getMessage().toLowerCase().contains("rate limit");
    }

    private void handleNetworkingException(IOException e, int attempt) throws IOException, InterruptedException {
        if (attempt >= this.maxAttempts) {
            throw new RuntimeException("A request to GitHub failed " + attempt + " times. Giving up", e);
        }
        this.log.warn((Object)"A request to GitHub failed. Will try again", (Throwable)e);
        long delayMillis = attempt == 1 ? TimeUnit.SECONDS.toMillis(5L) : (attempt == 2 ? TimeUnit.SECONDS.toMillis(30L) : TimeUnit.SECONDS.toMillis(120L));
        this.sleep(delayMillis, this.i18n.getText("com.atlassian.jira.plugins.importer.github.fetchData.warning.network", (Object)attempt));
    }

    private void sleep(long delayMillis, String reason) throws InterruptedException {
        long retryTime = System.currentTimeMillis() + delayMillis;
        while (retryTime > System.currentTimeMillis()) {
            long remainingDelay = retryTime - System.currentTimeMillis();
            long minutes = TimeUnit.MILLISECONDS.toMinutes(remainingDelay);
            long seconds = TimeUnit.MILLISECONDS.toSeconds(remainingDelay) - TimeUnit.MINUTES.toSeconds(minutes);
            String msg = reason + " " + this.i18n.getText("com.atlassian.jira.plugins.importer.github.fetchData.warning.retry", String.valueOf(minutes), String.valueOf(seconds));
            this.failureCallback.retry(msg);
            if (this.retryFeedbackInterval != null) {
                Thread.sleep(this.retryFeedbackInterval);
                continue;
            }
            Thread.sleep(delayMillis);
        }
    }

    public static interface FailureCallback {
        public void retry(String var1);

        public void retriesFinished();
    }
}

