/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.rest.workflow;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class WorkflowService {
    private final WorkflowManager workflowManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final ConstantsManager constantsManager;

    public WorkflowService(WorkflowManager workflowManager, WorkflowSchemeManager workflowSchemeManager, ConstantsManager constantsManager) {
        this.workflowManager = workflowManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.constantsManager = constantsManager;
    }

    public JiraWorkflow getWorkflow(String schemeName, String issueTypeId) {
        try {
            GenericValue scheme = this.workflowSchemeManager.getScheme(schemeName);
            return this.workflowManager.getWorkflowFromScheme(scheme, issueTypeId);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<JiraWorkflow> getSchemeWorkflows(String schemeName) {
        ArrayList<JiraWorkflow> workflows = new ArrayList<JiraWorkflow>();
        for (IssueType issueType : this.constantsManager.getAllIssueTypeObjects()) {
            workflows.add(this.getWorkflow(schemeName, issueType.getId()));
        }
        return workflows;
    }

    public String getDefaultSchemeName() {
        return "Default Workflow Scheme";
    }

    public List<String> getSchemeNames() {
        return Lists.transform((List)this.workflowSchemeManager.getSchemeObjects(), (Function)new Function<Scheme, String>(){

            public String apply(@Nullable Scheme input) {
                return input.getName();
            }
        });
    }
}

