/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.importer.markup;

import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.github.importer.DataBean;
import com.atlassian.jira.plugins.importer.github.importer.markup.SimpleConverter;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MentionConverter
implements SimpleConverter {
    private static final Pattern ghMentionPattern = Pattern.compile("(^|\\s)@([a-zA-z]+)($|\\s)");
    private final DataBean dataBean;

    public MentionConverter(DataBean dataBean) {
        this.dataBean = dataBean;
    }

    @Override
    public String convertMarkdown(String content) {
        Matcher matcher = ghMentionPattern.matcher(content);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            if (!this.doesUserExist(matcher.group(2))) continue;
            matcher.appendReplacement(buffer, "$1[~$2]$3");
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private boolean doesUserExist(final String username) {
        return Iterables.any(this.dataBean.getAllUserCache(), (Predicate)new Predicate<ExternalUser>(){

            public boolean apply(ExternalUser input) {
                return input.getName().equals(username);
            }
        });
    }
}

