/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.importer.markup;

import com.atlassian.jira.plugins.importer.github.importer.markup.NoFormatFragmentConverter;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeFragmentConverter
implements NoFormatFragmentConverter {
    private static final Pattern codePattern = Pattern.compile("```([a-zA-z]+)?(.*?)```", 32);
    private Set<Replacement> replacements = Sets.newHashSet();

    @Override
    public String removeNoFormatFragments(String content) {
        Matcher matcher = codePattern.matcher(content);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String temporaryReplacement = UUID.randomUUID().toString();
            String codeBlock = matcher.group(1) != null ? String.format("{code:%s}%s{code}", matcher.group(1), matcher.group(2)) : String.format("{code}%s{code}", matcher.group(2));
            matcher.appendReplacement(buffer, temporaryReplacement);
            this.replacements.add(new Replacement(temporaryReplacement, codeBlock));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    @Override
    public String putBackNoFormatFragments(String content) {
        for (Replacement replacement : this.replacements) {
            content = content.replace(replacement.tempReplacement, replacement.codeBlock);
        }
        return content;
    }

    private static class Replacement {
        private String tempReplacement;
        private String codeBlock;

        private Replacement(String tempReplacement, String codeBlock) {
            this.tempReplacement = tempReplacement;
            this.codeBlock = codeBlock;
        }
    }
}

