/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.importer;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComment;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.github.config.ConfigBean;
import com.atlassian.jira.plugins.importer.github.config.SchemeStatusMapping;
import com.atlassian.jira.plugins.importer.github.fetch.Project;
import com.atlassian.jira.plugins.importer.github.importer.Attachment;
import com.atlassian.jira.plugins.importer.github.importer.AttachmentManager;
import com.atlassian.jira.plugins.importer.github.importer.DataBean;
import com.atlassian.jira.plugins.importer.github.importer.markup.ConversionResult;
import com.atlassian.jira.plugins.importer.github.importer.markup.MarkupConverter;
import com.atlassian.jira.plugins.importer.github.rest.workflow.WorkflowService;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Label;

public class GithubIssueConverter {
    private final ConfigBean configBean;
    private final ConstantsManager constantsManager;
    private final WorkflowService workflowService;
    private final AttachmentManager attachmentManager = new AttachmentManager();
    private final Multimap<ExternalIssue, Attachment> issueAttachments = HashMultimap.create();
    private final MarkupConverter converter;
    private final I18nHelper i18nHelper;

    public GithubIssueConverter(ConfigBean configBean, ConstantsManager constantsManager, WorkflowManager workflowManager, WorkflowSchemeManager workflowSchemeManager, DataBean dataBean, I18nHelper i18nHelper) {
        this.configBean = configBean;
        this.constantsManager = constantsManager;
        this.i18nHelper = i18nHelper;
        this.workflowService = new WorkflowService(workflowManager, workflowSchemeManager, constantsManager);
        this.converter = new MarkupConverter(dataBean, configBean);
    }

    public ExternalIssue convertIssue(final Project project, Issue issue, ImportLogger importLogger, ExternalProject externalProject) {
        final ExternalIssue externalIssue = new ExternalIssue();
        externalIssue.setExternalId(String.valueOf(issue.getNumber()));
        externalIssue.setReporter(issue.getUser().getLogin());
        if (issue.getAssignee() != null) {
            externalIssue.setAssignee(issue.getAssignee().getLogin());
        }
        externalIssue.setSummary(issue.getTitle());
        externalIssue.setCreated(issue.getCreatedAt());
        externalIssue.setUpdated(issue.getUpdatedAt());
        String description = issue.getBody();
        if (description != null) {
            ConversionResult convert = this.converter.convert(project.getRepository(), description);
            this.issueAttachments.putAll((Object)externalIssue, convert.getAttachments());
            description = convert.getConvertedContent();
        }
        externalIssue.setDescription(description);
        IssueType issueType = this.applyLabels(issue, importLogger, externalIssue);
        if (issueType == null) {
            issueType = this.configBean.getDefaultIssueType(externalProject.getKey());
            externalIssue.setIssueType(issueType.getName());
        }
        JiraWorkflow workflow = this.workflowService.getWorkflow(this.configBean.getSchemeStatusMapping().getWorkflowSchemeName(), issueType.getId());
        SchemeStatusMapping.JiraStatusMapping jiraStatusMapping = this.configBean.getSchemeStatusMapping().getWorkflowIdToStatusMapping().get(workflow.getName());
        if (issue.getState().equals("open")) {
            externalIssue.setStatus(jiraStatusMapping.getOpenStatus());
        } else if (issue.getState().equals("closed")) {
            externalIssue.setStatus(jiraStatusMapping.getClosedStatus());
        } else {
            throw new IllegalStateException("Unknown GitHub issue state: " + issue.getState());
        }
        List<Comment> comments = this.configBean.getGithubDataService().getComments(issue);
        externalIssue.setComments((Collection)Lists.newArrayList((Iterable)Iterables.transform(comments, (Function)new Function<Comment, ExternalComment>(){

            public ExternalComment apply(@Nullable Comment comment) {
                String body = comment.getBody();
                if (body != null) {
                    ConversionResult convert = GithubIssueConverter.this.converter.convert(project.getRepository(), body);
                    GithubIssueConverter.this.issueAttachments.putAll((Object)externalIssue, convert.getAttachments());
                    body = convert.getConvertedContent();
                }
                return new ExternalComment(body, comment.getUser().getLogin(), comment.getCreatedAt());
            }
        })));
        if (issue.getMilestone() != null) {
            externalIssue.setFixedVersions((Iterable)Lists.newArrayList((Object[])new String[]{issue.getMilestone().getTitle()}));
        }
        return externalIssue;
    }

    @VisibleForTesting
    MappingResult getMapping(Iterable<Label> labels, final Map<String, Integer> mapping) {
        HashSet validResults = Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform(labels, (Function)new Function<Label, Integer>(){

            public Integer apply(Label input) {
                return (Integer)mapping.get(input.getName());
            }
        }), (Predicate)Predicates.notNull()));
        final ImmutableListMultimap resultToLabels = Multimaps.index(labels, (Function)new Function<Label, Integer>(){

            public Integer apply(Label input) {
                return mapping.containsKey(input.getName()) ? (Integer)mapping.get(input.getName()) : -1;
            }
        });
        if (validResults.size() == 1) {
            Integer validId = (Integer)validResults.iterator().next();
            return MappingResult.found(validId, (Iterable<Label>)resultToLabels.get((Object)validId));
        }
        if (validResults.size() == 0) {
            return MappingResult.noResult();
        }
        Iterable conflictingLabels = Iterables.concat((Iterable)Iterables.transform((Iterable)validResults, (Function)new Function<Integer, Iterable<Label>>(){

            public Iterable<Label> apply(Integer input) {
                return resultToLabels.get((Object)input);
            }
        }));
        return MappingResult.conflict(conflictingLabels);
    }

    @VisibleForTesting
    IssueType applyLabels(Issue issue, ImportLogger importLogger, ExternalIssue externalIssue) {
        MappingResult issueTypeResult = this.getMapping(issue.getLabels(), this.configBean.getIssueTypeMapping());
        MappingResult resolutionResult = this.getMapping(issue.getLabels(), this.configBean.getResolutionMappings());
        HashSet usedLabels = Sets.newHashSet();
        IssueType issueType = null;
        if (issueTypeResult.hasMapping()) {
            issueType = this.constantsManager.getIssueTypeObject(String.valueOf(issueTypeResult.resultId));
            externalIssue.setIssueType(issueType.getName());
            usedLabels.addAll(Lists.newArrayList((Iterable)issueTypeResult.sourceLabels));
        } else if (issueTypeResult.isConflict()) {
            importLogger.warn(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.github.import.conflict.issue.types", "" + issue.getNumber(), Joiner.on((String)", ").join(issueTypeResult.sourceLabels)), new Object[0]);
        }
        if (resolutionResult.hasMapping()) {
            Resolution resolution = this.constantsManager.getResolutionObject(String.valueOf(resolutionResult.resultId));
            externalIssue.setResolution(resolution.getName());
            usedLabels.addAll(Lists.newArrayList((Iterable)resolutionResult.sourceLabels));
        } else if (resolutionResult.isConflict()) {
            importLogger.warn(this.i18nHelper.getText("com.atlassian.jira.plugins.importer.github.import.conflict.resolutions", "" + issue.getNumber(), Joiner.on((String)", ").join(resolutionResult.sourceLabels)), new Object[0]);
        }
        if (this.configBean.isAutoLabels()) {
            HashSet unusedLabels = Sets.newHashSet((Iterable)issue.getLabels());
            Iterables.removeAll((Iterable)unusedLabels, (Collection)usedLabels);
            Iterable labelNames = Iterables.transform((Iterable)unusedLabels, (Function)new Function<Label, String>(){

                public String apply(Label input) {
                    return input.getName();
                }
            });
            externalIssue.setLabels((Collection)ImmutableList.copyOf((Iterable)labelNames));
        }
        return issueType;
    }

    public List<ExternalAttachment> downloadAttachmentsForIssue(ExternalIssue externalIssue, ImportLogger importLogger) {
        return this.attachmentManager.downloadAttachmentsForIssue(this.issueAttachments.get((Object)externalIssue), importLogger);
    }

    @VisibleForTesting
    static class MappingResult {
        private static final int CONFLICT = -2;
        private int resultId = -1;
        private Iterable<Label> sourceLabels = ImmutableList.of();

        public Iterable<Label> getSourceLabels() {
            return this.sourceLabels;
        }

        public int getResultId() {
            return this.resultId;
        }

        public boolean hasMapping() {
            return this.resultId > 0;
        }

        public boolean isConflict() {
            return this.resultId == -2;
        }

        private MappingResult() {
        }

        private MappingResult(int resultId, Iterable<Label> sourceLabels) {
            this.resultId = resultId;
            if (sourceLabels != null) {
                this.sourceLabels = Iterables.filter(sourceLabels, (Predicate)Predicates.notNull());
            }
        }

        public static MappingResult noResult() {
            return new MappingResult();
        }

        public static MappingResult found(int result, Iterable<Label> labels) {
            return new MappingResult(result, labels);
        }

        public static MappingResult conflict(Iterable<Label> labels) {
            return new MappingResult(-2, labels);
        }
    }
}

