/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.fetch.auth;

import com.atlassian.jira.plugins.importer.github.fetch.RobustGitHubClient;
import com.atlassian.jira.plugins.importer.github.fetch.auth.GithubAuthenticator;
import com.atlassian.jira.plugins.importer.github.util.HttpClientFactory;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.UserService;

public class GithubAuthenticatorImpl
implements GithubAuthenticator {
    public static final String IMPORTER_TOKEN_NAME = "JIRA-Github-Importer";
    private final Logger log = Logger.getLogger(this.getClass());
    private static final String GITHUB_CLASSIC_URL = "https://api.github.com";
    private final I18nHelper i18nHelper;
    private final HttpClient client = HttpClientFactory.createHttpClient();
    private String username;
    private String url;
    private String password;
    private String validAuthToken;
    private boolean is2FA = false;
    private boolean isEnterprise = false;
    private int authorizationId = -1;

    public GithubAuthenticatorImpl(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    @Override
    public void setGithubEnterpriseUrl(String url) {
        this.url = url;
        this.isEnterprise = true;
    }

    @Override
    public GithubAuthenticator.AuthorizationResponse authenticateGithub(String username, String password) {
        this.username = username;
        this.password = password;
        return this.getAccessToken(null);
    }

    @Override
    public GithubAuthenticator.AuthorizationResponse authenticateAndValidateGithubToken(String token) {
        GitHubClient gitHubClient = this.buildAuthenticatedClient(token);
        UserService userService = new UserService(gitHubClient);
        try {
            User user = userService.getUser();
            if (user != null) {
                this.validAuthToken = token;
                return GithubAuthenticator.AuthorizationResponse.ok(token);
            }
        }
        catch (IOException e) {
            return GithubAuthenticator.AuthorizationResponse.error("Invalid token");
        }
        return GithubAuthenticator.AuthorizationResponse.error("Invalid token");
    }

    @Override
    public GithubAuthenticator.AuthorizationResponse tryAuthenticateWith2FAToken(String key) throws IllegalStateException {
        return this.getAccessToken(key);
    }

    private String getText(String key) {
        return this.i18nHelper.getText(key);
    }

    private String getText(String key, Object ... args) {
        return this.i18nHelper.getText(key, (Object)args);
    }

    private GithubAuthenticator.AuthorizationResponse getAccessToken(@Nullable String key) {
        try {
            GithubAuthenticator.AuthorizationResponse newAccessTokenRequest = this.createNewAccessToken(key);
            if (newAccessTokenRequest.getState() == GithubAuthenticator.AuthState.ERROR && "This authorization seems to already exist and is not compatible with current importer".equals(newAccessTokenRequest.getError())) {
                int authorizationId = this.getAuthorizationId(key);
                this.deleteAuthorization(authorizationId, key);
                newAccessTokenRequest = this.createNewAccessToken(key);
            }
            return newAccessTokenRequest;
        }
        catch (IOException e) {
            String message = this.getText("com.atlassian.jira.plugins.importer.github.error.cannot.connect", e.getMessage());
            this.log.error((Object)message, (Throwable)e);
            return GithubAuthenticator.AuthorizationResponse.error(message);
        }
        catch (Exception e) {
            String message = this.getText("com.atlassian.jira.plugins.importer.github.error.unknown", e.getMessage());
            this.log.error((Object)message, (Throwable)e);
            return GithubAuthenticator.AuthorizationResponse.error(message);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GithubAuthenticator.AuthorizationResponse createNewAccessToken(@Nullable String key) throws Exception {
        requestUrl = UriBuilder.fromPath((String)(this.buildAPIUrl() + "/authorizations")).build(new Object[0]).toString();
        request = null;
        inputStream = null;
        try {
            request = new HttpPost(requestUrl);
            request.addHeader(BasicScheme.authenticate((Credentials)new UsernamePasswordCredentials(this.username, this.password), (String)"UTF-8", (boolean)false));
            request.setEntity((HttpEntity)new StringEntity(AuthorizationRequest.getDefaultAsJson()));
            if (key != null) {
                request.addHeader("X-GitHub-OTP", key);
            }
            response = this.client.execute((HttpUriRequest)request);
            inputStream = response.getEntity().getContent();
            statusLine = response.getStatusLine();
            statusCode = statusLine.getStatusCode();
            if (statusCode == 201) ** GOTO lbl37
            if (statusCode == 422) {
                request.abort();
                var8_10 = GithubAuthenticator.AuthorizationResponse.alreadyExists();
            }
            ** GOTO lbl-1000
        }
        catch (IOException e) {
            try {
                throw e;
                catch (Exception e) {
                    if (request != null) {
                        request.abort();
                    }
                    throw e;
                }
            }
            catch (Throwable var11_15) {
                IOUtils.closeQuietly(inputStream);
                throw var11_15;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return var8_10;
lbl-1000:
        // 1 sources

        {
            if (statusCode != 401) ** GOTO lbl-1000
            var8_11 = this.handleUnauthorized(response);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return var8_11;
lbl-1000:
        // 1 sources

        {
            throw new IOException(this.getText("com.atlassian.jira.plugins.importer.github.error.incorrect.status", new Object[]{statusLine}));
lbl37:
            // 1 sources

            parser = new JsonParser();
            jsonRoot = parser.parse((Reader)new InputStreamReader(inputStream, "UTF-8"));
            this.authorizationId = jsonRoot.getAsJsonObject().get("id").getAsInt();
            this.validAuthToken = jsonRoot.getAsJsonObject().get("token").getAsString();
            var10_14 = GithubAuthenticator.AuthorizationResponse.ok(this.validAuthToken);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return var10_14;
    }

    private int getAuthorizationId(String key) throws IOException {
        int n;
        String requestUrl = UriBuilder.fromPath((String)(this.buildAPIUrl() + "/authorizations")).build(new Object[0]).toString();
        HttpGet request = null;
        InputStream inputStream = null;
        try {
            request = new HttpGet(requestUrl);
            request.addHeader(BasicScheme.authenticate((Credentials)new UsernamePasswordCredentials(this.username, this.password), (String)"UTF-8", (boolean)false));
            if (key != null) {
                request.addHeader("X-GitHub-OTP", key);
            }
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            inputStream = response.getEntity().getContent();
            n = this.getAuthorizationId(inputStream);
        }
        catch (RuntimeException e) {
            try {
                if (request != null) {
                    request.abort();
                }
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return n;
    }

    private int getAuthorizationId(InputStream inputStream) throws IOException {
        JsonParser parser = new JsonParser();
        JsonElement jsonRoot = parser.parse((Reader)new InputStreamReader(inputStream, "UTF-8"));
        JsonArray array = jsonRoot.getAsJsonArray();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject authorization = array.get(i).getAsJsonObject();
            JsonElement note = authorization.get("note");
            if (note == null || !note.isJsonPrimitive() || !IMPORTER_TOKEN_NAME.equals(note.getAsString())) continue;
            this.authorizationId = authorization.get("id").getAsInt();
            return this.authorizationId;
        }
        throw new IOException("Cannot find auth token for: JIRA-Github-Importer");
    }

    private void deleteAuthorization(int authorizationId, String key) throws Exception {
        String requestUrl = UriBuilder.fromPath((String)(this.buildAPIUrl() + "/authorizations/" + authorizationId)).build(new Object[0]).toString();
        HttpDelete request = null;
        try {
            request = new HttpDelete(requestUrl);
            request.addHeader(BasicScheme.authenticate((Credentials)new UsernamePasswordCredentials(this.username, this.password), (String)"UTF-8", (boolean)false));
            if (key != null) {
                request.addHeader("X-GitHub-OTP", key);
            }
            this.client.execute((HttpUriRequest)request);
        }
        catch (RuntimeException e) {
            if (request != null) {
                request.abort();
            }
            throw e;
        }
    }

    private GithubAuthenticator.AuthorizationResponse handleUnauthorized(HttpResponse response) {
        Optional<String> faHeader = this.get2FAHeader(response);
        if (faHeader.isPresent()) {
            this.is2FA = true;
            if ("app".equals(faHeader.get())) {
                return GithubAuthenticator.AuthorizationResponse.actionRequired(GithubAuthenticator.AuthState.TWO_FACTOR_AUTH_REQUIRED_APP);
            }
            return GithubAuthenticator.AuthorizationResponse.actionRequired(GithubAuthenticator.AuthState.TWO_FACTOR_AUTH_REQUIRED_SMS);
        }
        return GithubAuthenticator.AuthorizationResponse.error(this.getText("com.atlassian.jira.plugins.importer.github.error.incorrect.username.or.password"));
    }

    private String buildAPIUrl() {
        if (this.isEnterprise) {
            return String.format("%s/api/v3", this.url);
        }
        return GITHUB_CLASSIC_URL;
    }

    private Optional<String> get2FAHeader(HttpResponse response) {
        Header header = response.getFirstHeader("X-GitHub-OTP");
        if (header == null) {
            return Optional.absent();
        }
        Iterable tokens = Splitter.on((char)';').trimResults().split((CharSequence)header.getValue());
        return Optional.of((Object)Iterables.get((Iterable)tokens, (int)1));
    }

    @Override
    public boolean isTwoFactorAuthenticationEnabled() {
        return this.is2FA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteAuthorization() {
        String requestUrl = UriBuilder.fromPath((String)(this.buildAPIUrl() + "/authorizations/" + this.authorizationId)).build(new Object[0]).toString();
        HttpDelete httpDelete = null;
        InputStream is = null;
        try {
            httpDelete = new HttpDelete(requestUrl);
            HttpResponse response = this.client.execute((HttpUriRequest)httpDelete);
            if (response.getStatusLine().getStatusCode() != 204) {
                this.log.warn((Object)("Cannot delete github authorization with id: " + this.authorizationId));
            }
            is = response.getEntity().getContent();
            IOUtils.closeQuietly((InputStream)is);
            return;
        }
        catch (RuntimeException e) {
            if (httpDelete == null) throw e;
            httpDelete.abort();
            throw e;
            catch (IOException e2) {
                this.log.warn((Object)("Cannot delete github authorization with id: " + this.authorizationId));
                return;
            }
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    @Override
    public void cleanUp() {
        if (this.authorizationId > 0) {
            this.deleteAuthorization();
        }
        this.authorizationId = -1;
        this.username = null;
        this.password = null;
        this.url = null;
        this.client.getConnectionManager().shutdown();
    }

    @Override
    public GitHubClient buildAuthenticatedClient() {
        return this.buildAuthenticatedClient(this.validAuthToken);
    }

    public GitHubClient buildAuthenticatedClient(String authToken) {
        RobustGitHubClient robustGitHubClient;
        if (this.url != null) {
            try {
                URL objectUrl = new URL(this.url);
                robustGitHubClient = new RobustGitHubClient(objectUrl.getHost(), objectUrl.getPort(), objectUrl.getProtocol());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        } else {
            robustGitHubClient = new RobustGitHubClient();
        }
        robustGitHubClient.setOAuth2Token(authToken);
        return robustGitHubClient;
    }

    private static class AuthorizationRequest {
        public String[] scopes;
        public String note;

        private AuthorizationRequest(String[] scopes, String note) {
            this.scopes = scopes;
            this.note = note;
        }

        public static AuthorizationRequest getDefault() {
            return new AuthorizationRequest(new String[]{"repo"}, GithubAuthenticatorImpl.IMPORTER_TOKEN_NAME);
        }

        public static String getDefaultAsJson() throws IOException {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)AuthorizationRequest.getDefault());
        }
    }
}

