/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github;

import com.atlassian.jira.plugins.importer.github.GithubImportProcessBean;
import com.atlassian.jira.plugins.importer.github.config.ConfigBean;
import com.atlassian.jira.plugins.importer.github.fetch.DataFetchJob;
import com.atlassian.jira.plugins.importer.github.fetch.GithubDataService;
import com.atlassian.jira.plugins.importer.github.fetch.auth.GithubAuthenticator;
import com.atlassian.jira.plugins.importer.github.fetch.auth.GithubAuthenticatorImpl;
import com.atlassian.jira.plugins.importer.github.importer.DataBean;
import com.atlassian.jira.plugins.importer.github.web.GithubAuthenticationPage;
import com.atlassian.jira.plugins.importer.github.web.GithubFetchDataPage;
import com.atlassian.jira.plugins.importer.github.web.GithubLabelMappingPage;
import com.atlassian.jira.plugins.importer.github.web.GithubProjectMappingPage;
import com.atlassian.jira.plugins.importer.github.web.GithubSetupPage;
import com.atlassian.jira.plugins.importer.github.web.GithubWorkflowPage;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.web.AbstractImporterController;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GithubImporterController
extends AbstractImporterController {
    public static final String IMPORT_CONFIG_BEAN = "com.atlassian.jira.plugins.importer.github.config";
    public static final String IMPORT_ID = "Github";
    public static final String EXTERNAL_SYSTEM = "com.atlassian.jira.plugins.jira-importers-github-plugin:githubImporterKey";
    private final ConfigFileHandler configFileHandler;
    private final I18nHelper i18nHelper;

    public GithubImporterController(@ComponentImport JiraDataImporter importer, @ComponentImport ConfigFileHandler configFileHandler, @ComponentImport I18nHelper i18nHelper) {
        super(importer, IMPORT_CONFIG_BEAN, IMPORT_ID);
        this.configFileHandler = configFileHandler;
        this.i18nHelper = i18nHelper;
    }

    public boolean createImportProcessBean(AbstractSetupPage abstractSetupPage) {
        GithubDataService githubDataService = new GithubDataService();
        DataFetchJob dataFetchJob = new DataFetchJob(githubDataService);
        ConfigBean configBean = new ConfigBean(githubDataService);
        GithubAuthenticatorImpl githubAuthenticator = new GithubAuthenticatorImpl(this.i18nHelper);
        GithubImportProcessBean bean = new GithubImportProcessBean(githubDataService, dataFetchJob, configBean, githubAuthenticator);
        GithubSetupPage githubSetupPage = (GithubSetupPage)abstractSetupPage;
        if (!this.configFileHandler.populateFromConfigFile((AbstractSetupPage)githubSetupPage, (AbstractConfigBean)configBean)) {
            return false;
        }
        if (!githubSetupPage.isGithubClassic()) {
            configBean.setGithubUrl(githubSetupPage.getGithubUrl());
            configBean.setGithubEnterprise(true);
            githubAuthenticator.setGithubEnterpriseUrl(githubSetupPage.getGithubUrl());
        }
        if (!this.validateGithubEnterprise(githubSetupPage, bean)) {
            return false;
        }
        this.storeImportProcessBeanInSession(bean);
        return true;
    }

    private boolean validateGithubEnterprise(GithubSetupPage githubSetupPage, GithubImportProcessBean processBean) {
        GithubAuthenticator authenticator = processBean.getAuthenticator();
        GithubAuthenticator.AuthorizationResponse authorizationResponse = StringUtils.isNotBlank((String)githubSetupPage.getGithubToken()) ? authenticator.authenticateAndValidateGithubToken(githubSetupPage.getGithubToken()) : authenticator.authenticateGithub(githubSetupPage.getGithubUsername(), githubSetupPage.getGithubPassword());
        if (authorizationResponse.getState() == GithubAuthenticator.AuthState.ERROR) {
            githubSetupPage.addErrorMessage(authorizationResponse.getError());
            return false;
        }
        if (authorizationResponse.getState() == GithubAuthenticator.AuthState.OK) {
            processBean.getGithubDataService().setGitHubClient(authenticator.buildAuthenticatedClient());
        }
        return true;
    }

    public ImportDataBean createDataBean() throws Exception {
        GithubImportProcessBean importProcessBean = (GithubImportProcessBean)this.getImportProcessBeanFromSession();
        if (importProcessBean == null) {
            throw new IllegalStateException("No active importer");
        }
        ConfigBean configBean = (ConfigBean)importProcessBean.getConfigBean();
        return new DataBean(configBean, importProcessBean, this.i18nHelper);
    }

    public List<String> getStepNameKeys() {
        return Lists.newArrayList((Object[])new String[]{"com.atlassian.jira.plugins.importer.github.step.setup", "com.atlassian.jira.plugins.importer.github.step.oauth", "com.atlassian.jira.plugins.importer.github.step.projectMapping", "com.atlassian.jira.plugins.importer.github.step.fetchData", "com.atlassian.jira.plugins.importer.github.step.labelMapping", "com.atlassian.jira.plugins.importer.github.step.workflow"});
    }

    public List<String> getSteps() {
        return Lists.newArrayList((Object[])new String[]{GithubSetupPage.class.getSimpleName(), GithubAuthenticationPage.class.getSimpleName(), GithubProjectMappingPage.class.getSimpleName(), GithubFetchDataPage.class.getSimpleName(), GithubLabelMappingPage.class.getSimpleName(), GithubWorkflowPage.class.getSimpleName()});
    }
}

