/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.web;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterClient;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterConfigBean;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.collect.ImmutableList;
import javax.servlet.http.HttpServletRequest;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

public class ReceiveOauthCodePage
extends AbstractSetupPage {
    public ReceiveOauthCodePage(@ComponentImport UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport EventPublisher eventPublisher) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, eventPublisher);
    }

    public String doDefault() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        BitbucketImporterConfigBean configBean = this.getConfigBean();
        if (configBean == null) {
            return "restartimporterneeded";
        }
        BitbucketImporterClient client = configBean.getBitbucketImporterClient();
        if (client == null) {
            return "restartimporterneeded";
        }
        OAuthService service = client.getService();
        Token requestToken = (Token)ActionContext.getSession().get("issue.importer.jira.bitbucket.oauthRequestToken");
        String token = request.getParameter("oauth_token");
        String verifier = request.getParameter("oauth_verifier");
        Token accessToken = null;
        if (token != null && verifier != null) {
            accessToken = service.getAccessToken(requestToken, new Verifier(verifier));
        }
        if (accessToken != null) {
            client.setAccessToken(accessToken);
            client.loadCurrentUserData();
        } else {
            this.addError("accessToken", this.getText("com.atlassian.jira.plugins.importer.bitbucket.receiveOauthCode.error.userDeniedAccess"));
        }
        return "input";
    }

    public int getCurrentStep() {
        return 1;
    }

    public BitbucketImporterConfigBean getConfigBean() {
        try {
            if (this.getController() == null || this.getController().getImportProcessBeanFromSession() == null) {
                return null;
            }
            return (BitbucketImporterConfigBean)this.getController().getImportProcessBeanFromSession().getConfigBean();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Iterable<String> getRequiredResources() {
        return ImmutableList.of((Object)"com.atlassian.jira.plugins.jira-importers-bitbucket-plugin:receiveOauthCodePage");
    }
}

