/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.web;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImportProcessBean;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterConfigBean;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterController;
import com.atlassian.jira.plugins.importer.bitbucket.fetch.BackCompatibilityUtil;
import com.atlassian.jira.plugins.importer.bitbucket.fetch.DataFetchJob;
import com.atlassian.jira.plugins.importer.bitbucket.fetch.VoidOut;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.collect.ImmutableList;

public class FetchDataPage
extends AbstractSetupPage {
    private static final String BUTTON_NAME_CANCEL = "cancelBtn";
    private static final String BUTTON_NAME_FINISH = "finishBtn";
    private final TaskManager taskManager;

    public FetchDataPage(@ComponentImport UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport TaskManager taskManager, @ComponentImport EventPublisher eventPublisher) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, eventPublisher);
        this.taskManager = taskManager;
    }

    public String doDefault() throws Exception {
        BitbucketImporterController controller = (BitbucketImporterController)this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        BitbucketImportProcessBean bitbucketImportProcessBean = this.getBitbucketImportProcessBean();
        if (bitbucketImportProcessBean == null) {
            return "restartimporterneeded";
        }
        BitbucketImporterConfigBean configBean = (BitbucketImporterConfigBean)bitbucketImportProcessBean.getConfigBean();
        if (configBean == null) {
            return "restartimporterneeded";
        }
        DataFetchJob dataFetchJob = bitbucketImportProcessBean.getDataFetchJob();
        if (dataFetchJob == null) {
            return "restartimporterneeded";
        }
        dataFetchJob.startFetching(this.taskManager, configBean.getSelectedProjects());
        return "input";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        BitbucketImporterController controller = (BitbucketImporterController)this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        BitbucketImportProcessBean bitbucketImportProcessBean = this.getBitbucketImportProcessBean();
        if (bitbucketImportProcessBean == null) {
            return "restartimporterneeded";
        }
        DataFetchJob dataFetchJob = bitbucketImportProcessBean.getDataFetchJob();
        if (dataFetchJob == null) {
            return "restartimporterneeded";
        }
        if (this.isCancelClicked()) {
            TaskDescriptor<VoidOut> taskDescriptor = dataFetchJob.getFetchingTask();
            if (taskDescriptor != null) {
                BackCompatibilityUtil.cancelTask(taskDescriptor, this.taskManager);
            }
            return "input";
        }
        if (this.isButtonClickedByName(BUTTON_NAME_FINISH)) {
            return this.getRedirect("ExternalImport1.jspa?atl_token=" + this.getXsrfToken());
        }
        return "restartimporterneeded";
    }

    public int getCurrentStep() {
        return 2;
    }

    public String getFormTitle() {
        return this.getText("com.atlassian.jira.plugins.importer.bitbucket.fetchData.title");
    }

    protected boolean isCancelClicked() {
        return this.isButtonClickedByName(BUTTON_NAME_CANCEL);
    }

    public Iterable<String> getRequiredResources() {
        return ImmutableList.of((Object)"com.atlassian.jira.plugins.jira-importers-bitbucket-plugin:fetchDataPage");
    }

    private BitbucketImportProcessBean getBitbucketImportProcessBean() {
        try {
            if (this.getController() == null || this.getController().getImportProcessBeanFromSession() == null) {
                return null;
            }
            return (BitbucketImportProcessBean)this.getController().getImportProcessBeanFromSession();
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

