/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.transformer;

import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterConfigBean;
import com.atlassian.jira.plugins.importer.bitbucket.model.Project;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.google.common.base.Function;

public class ProjectTransformer
implements Function<Project, ExternalProject> {
    private final BitbucketImporterConfigBean configBean;

    public ProjectTransformer(BitbucketImporterConfigBean configBean) {
        this.configBean = configBean;
    }

    public ExternalProject apply(Project input) {
        String projectName = input.getName();
        ExternalProject externalProject = new ExternalProject();
        externalProject.setId(projectName);
        externalProject.setExternalName(projectName);
        externalProject.setUrl(String.format("https://bitbucket.org/%s/issues", projectName));
        externalProject.setKey(this.configBean.getProjectKey(projectName));
        externalProject.setName(this.configBean.getProjectName(projectName));
        externalProject.setLead(this.configBean.getProjectLead(projectName));
        ValueMappingHelper helper = this.configBean.getValueMappingHelper();
        if (helper.isWorkflowSchemeDefined()) {
            externalProject.setWorkflowSchemeName(helper.getWorkflowSchemeName());
        }
        return externalProject;
    }
}

