/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.transformer;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class MarkupTransformer
implements Function<String, String> {
    private static final Pattern BOLD_PATTERN = Pattern.compile("\\*\\*");
    private static final Pattern ITALIC_PATTERN = Pattern.compile("__");
    private static final Pattern HEADER4_PATTERN = Pattern.compile("^#### (.+?) ####$");
    private static final Pattern HEADER3_PATTERN = Pattern.compile("^### (.+?) ###$");
    private static final Pattern HEADER2_PATTERN = Pattern.compile("^## (.+?) ##$");
    private static final Pattern HEADER_PATTERN = Pattern.compile("^# (.+?) #$");
    private static final Pattern PUNCTUATION_PATTERN = Pattern.compile("^1\\. (.+)$");
    private static final Pattern IMAGE_PATTERN = Pattern.compile("\\!\\[([^\\]]+)\\]\\(([^)]+)\\)");
    private static final Pattern LINK_PATTERN = Pattern.compile("\\[([^\\]]+)\\]\\(([^)]+)\\)");
    private static final Pattern CODE_PATTERN = Pattern.compile("(?s)```.?#!([^\n]+)\n?(.*)```");

    public String apply(@Nullable String input) {
        if (input == null) {
            return null;
        }
        Object[] lines = input.split("\r?\n");
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = BOLD_PATTERN.matcher((CharSequence)lines[i]).replaceAll("*");
            lines[i] = ITALIC_PATTERN.matcher((CharSequence)lines[i]).replaceAll("_");
            lines[i] = HEADER4_PATTERN.matcher((CharSequence)lines[i]).replaceAll("h4. $1");
            lines[i] = HEADER3_PATTERN.matcher((CharSequence)lines[i]).replaceAll("h3. $1");
            lines[i] = HEADER2_PATTERN.matcher((CharSequence)lines[i]).replaceAll("h2. $1");
            lines[i] = HEADER_PATTERN.matcher((CharSequence)lines[i]).replaceAll("h1. $1");
            lines[i] = PUNCTUATION_PATTERN.matcher((CharSequence)lines[i]).replaceAll("# $1");
            lines[i] = IMAGE_PATTERN.matcher((CharSequence)lines[i]).replaceAll("$1 !$2!");
            lines[i] = LINK_PATTERN.matcher((CharSequence)lines[i]).replaceAll("[$1|$2]");
        }
        return CODE_PATTERN.matcher(Joiner.on((String)"\n").join(lines)).replaceAll("{code:$1}\n$2{code}");
    }
}

