/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.scribe;

import com.atlassian.jira.plugins.importer.bitbucket.scribe.DoWithSalCallback;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.scribe.builder.api.DefaultApi10a;
import org.scribe.model.OAuthConfig;
import org.scribe.model.OAuthConstants;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Request;
import org.scribe.model.RequestTuner;
import org.scribe.model.SalOAuthRequest;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import org.scribe.utils.MapUtils;

public class SalOAuth10aServiceImpl
implements OAuthService {
    private static final String VERSION = "1.0";
    private OAuthConfig config;
    private DefaultApi10a api;

    public SalOAuth10aServiceImpl(DefaultApi10a api, OAuthConfig config) {
        this.api = api;
        this.config = config;
    }

    public Token getRequestToken(int timeout, TimeUnit unit) {
        return this.getRequestToken(new TimeoutTuner(timeout, unit));
    }

    public Token getRequestToken() {
        return this.getRequestToken(2, TimeUnit.SECONDS);
    }

    public Token getRequestToken(RequestTuner tuner) {
        this.config.log("obtaining request token from " + this.api.getRequestTokenEndpoint());
        SalOAuthRequest request = new SalOAuthRequest(this.api.getRequestTokenVerb(), this.api.getRequestTokenEndpoint());
        this.config.log("setting oauth_callback to " + this.config.getCallback());
        request.addOAuthParameter("oauth_callback", this.config.getCallback());
        this.addOAuthParams(request, OAuthConstants.EMPTY_TOKEN);
        this.appendSignature(request);
        this.config.log("sending request...");
        String body = request.sendViaSal(new DoWithSalCallback<String>(){

            @Override
            protected String afterHandleResponse(Response response) throws ResponseException {
                String bodyString = response.getResponseBodyAsString();
                SalOAuth10aServiceImpl.this.config.log("response status code: " + response.getStatusCode());
                SalOAuth10aServiceImpl.this.config.log("response body: " + bodyString);
                return bodyString;
            }
        });
        return this.api.getRequestTokenExtractor().extract(body);
    }

    private void addOAuthParams(OAuthRequest request, Token token) {
        request.addOAuthParameter("oauth_timestamp", this.api.getTimestampService().getTimestampInSeconds());
        request.addOAuthParameter("oauth_nonce", this.api.getTimestampService().getNonce());
        request.addOAuthParameter("oauth_consumer_key", this.config.getApiKey());
        request.addOAuthParameter("oauth_signature_method", this.api.getSignatureService().getSignatureMethod());
        request.addOAuthParameter("oauth_version", this.getVersion());
        if (this.config.hasScope()) {
            request.addOAuthParameter("scope", this.config.getScope());
        }
        request.addOAuthParameter("oauth_signature", this.getSignature(request, token));
        this.config.log("appended additional OAuth parameters: " + MapUtils.toString((Map)request.getOauthParameters()));
    }

    public Token getAccessToken(Token requestToken, Verifier verifier, int timeout, TimeUnit unit) {
        return this.getAccessToken(requestToken, verifier, new TimeoutTuner(timeout, unit));
    }

    public Token getAccessToken(Token requestToken, Verifier verifier) {
        return this.getAccessToken(requestToken, verifier, 4, TimeUnit.SECONDS);
    }

    public Token getAccessToken(Token requestToken, Verifier verifier, RequestTuner tuner) {
        this.config.log("obtaining access token from " + this.api.getAccessTokenEndpoint());
        SalOAuthRequest request = new SalOAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        request.addOAuthParameter("oauth_token", requestToken.getToken());
        request.addOAuthParameter("oauth_verifier", verifier.getValue());
        this.config.log("setting token to: " + requestToken + " and verifier to: " + verifier);
        this.addOAuthParams(request, requestToken);
        this.appendSignature(request);
        String tokenData = request.sendViaSal(new DoWithSalCallback<String>(){

            @Override
            protected String afterHandleResponse(Response response) throws ResponseException {
                return response.getResponseBodyAsString();
            }
        });
        return this.api.getAccessTokenExtractor().extract(tokenData);
    }

    public void signRequest(Token token, OAuthRequest request) {
        this.config.log("signing request: " + request.getCompleteUrl());
        if (!token.isEmpty()) {
            request.addOAuthParameter("oauth_token", token.getToken());
        }
        this.config.log("setting token to: " + token);
        this.addOAuthParams(request, token);
        this.appendSignature(request);
    }

    public String getVersion() {
        return VERSION;
    }

    public String getAuthorizationUrl(Token requestToken) {
        return this.api.getAuthorizationUrl(requestToken);
    }

    private String getSignature(OAuthRequest request, Token token) {
        this.config.log("generating signature...");
        String baseString = this.api.getBaseStringExtractor().extract(request);
        String signature = this.api.getSignatureService().getSignature(baseString, this.config.getApiSecret(), token.getSecret());
        this.config.log("base string is: " + baseString);
        this.config.log("signature is: " + signature);
        return signature;
    }

    private void appendSignature(OAuthRequest request) {
        switch (this.config.getSignatureType()) {
            case Header: {
                this.config.log("using Http Header signature");
                String oauthHeader = this.api.getHeaderExtractor().extract(request);
                request.addHeader("Authorization", oauthHeader);
                break;
            }
            case QueryString: {
                this.config.log("using Querystring signature");
                for (Map.Entry entry : request.getOauthParameters().entrySet()) {
                    request.addQuerystringParameter((String)entry.getKey(), (String)entry.getValue());
                }
                break;
            }
        }
    }

    private static class TimeoutTuner
    extends RequestTuner {
        private final int duration;
        private final TimeUnit unit;

        public TimeoutTuner(int duration, TimeUnit unit) {
            this.duration = duration;
            this.unit = unit;
        }

        public void tune(Request request) {
            request.setReadTimeout(this.duration, this.unit);
            request.setConnectTimeout(this.duration, this.unit);
        }
    }
}

