/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.rest;

import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImportProcessBean;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterController;
import com.atlassian.jira.plugins.importer.bitbucket.fetch.DataFetchJob;
import com.atlassian.jira.plugins.importer.bitbucket.fetch.FetchSummaryProgress;
import com.atlassian.jira.plugins.importer.extensions.ExternalSystemImporterModuleDescriptor;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

@Path(value="fetchData")
public class FetchDataService {
    private final Logger log = Logger.getLogger(this.getClass());
    private final JiraAuthenticationContext authenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final PluginAccessor pluginAccessor;

    public FetchDataService(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport PluginAccessor pluginAccessor) {
        this.authenticationContext = authenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.pluginAccessor = pluginAccessor;
    }

    @GET
    @Path(value="/{externalSystem}/progress")
    @Produces(value={"application/json"})
    public Response getProgress(@Context HttpServletRequest req, @PathParam(value="externalSystem") String externalSystem) {
        if (this.isNotAdministrator()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.log.debug((Object)"Returning data fetch progress");
        HttpSession session = req.getSession(false);
        BitbucketImporterController controller = this.getController(externalSystem);
        if (session == null || controller == null) {
            return Response.status((Response.Status)Response.Status.GONE).entity((Object)"No active importer found").build();
        }
        BitbucketImportProcessBean bitbucketImportProcessBean = (BitbucketImportProcessBean)controller.getImportProcessBean(session);
        DataFetchJob dataFetchJob = bitbucketImportProcessBean.getDataFetchJob();
        String json = this.toJSON(dataFetchJob.getFetchProgress());
        return Response.ok((Object)json).build();
    }

    protected boolean isNotAdministrator() {
        ApplicationUser currentUser = this.authenticationContext.getUser();
        return currentUser == null || !this.globalPermissionManager.hasPermission(0, currentUser);
    }

    private BitbucketImporterController getController(String externalSystem) {
        ExternalSystemImporterModuleDescriptor moduleDescriptor = (ExternalSystemImporterModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(externalSystem);
        if (moduleDescriptor == null) {
            throw new RuntimeException("No active ImporterController found");
        }
        return (BitbucketImporterController)((Object)moduleDescriptor.getModule());
    }

    private String toJSON(FetchSummaryProgress fetchProgress) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)fetchProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

