/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.mapping;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.plugins.importer.bitbucket.model.BitbucketStatus;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;

public class ResolutionValueMappingDefinition
implements ValueMappingDefinition {
    private final ConstantsManager constantsManager;

    public ResolutionValueMappingDefinition(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    public String getExternalFieldId() {
        return "resolution";
    }

    public String getDescription() {
        return null;
    }

    public Set<String> getDistinctValues() {
        return BitbucketStatus.ALL_VALUES;
    }

    public String getJiraFieldId() {
        return "resolution";
    }

    public Collection<ValueMappingEntry> getTargetValues() {
        return Collections2.transform((Collection)this.constantsManager.getResolutionObjects(), (Function)new Function<Resolution, ValueMappingEntry>(){

            public ValueMappingEntry apply(Resolution input) {
                return new ValueMappingEntry(input.getName(), input.getId());
            }
        });
    }

    public Collection<ValueMappingEntry> getDefaultValues() {
        return ImmutableList.of((Object)new ValueMappingEntry(BitbucketStatus.ON_HOLD.getValue(), Integer.valueOf(5)), (Object)new ValueMappingEntry(BitbucketStatus.RESOLVED.getValue(), Integer.valueOf(1)), (Object)new ValueMappingEntry(BitbucketStatus.DUPLICATE.getValue(), Integer.valueOf(3)), (Object)new ValueMappingEntry(BitbucketStatus.INVALID.getValue(), Integer.valueOf(4)), (Object)new ValueMappingEntry(BitbucketStatus.WONTFIX.getValue(), Integer.valueOf(2)));
    }

    public boolean canBeBlank() {
        return true;
    }

    public boolean canBeImportedAsIs() {
        return false;
    }

    public boolean canBeCustom() {
        return false;
    }

    public boolean isMandatory() {
        return false;
    }
}

