/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.mapping;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.plugins.importer.imports.config.AbstractValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Set;

public class PriorityValueMappingDefinition
implements ValueMappingDefinition {
    private static final String PRIORITY = "priority";
    private static final String TRIVIAL = "trivial";
    private static final String MINOR = "minor";
    private static final String MAJOR = "major";
    private static final String CRITICAL = "critical";
    private static final String BLOCKER = "blocker";
    private final ConstantsManager constantsManager;

    public PriorityValueMappingDefinition(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    public String getJiraFieldId() {
        return PRIORITY;
    }

    public Collection<ValueMappingEntry> getTargetValues() {
        return Lists.newArrayList((Iterable)Collections2.transform((Collection)this.constantsManager.getPriorityObjects(), (Function)new AbstractValueMappingDefinition.IssueConstantToValueMapping()));
    }

    public boolean canBeImportedAsIs() {
        return true;
    }

    public String getExternalFieldId() {
        return PRIORITY;
    }

    public String getDescription() {
        return null;
    }

    public Set<String> getDistinctValues() {
        return ImmutableSet.of((Object)TRIVIAL, (Object)MINOR, (Object)MAJOR, (Object)CRITICAL, (Object)BLOCKER);
    }

    public Collection<ValueMappingEntry> getDefaultValues() {
        return ImmutableList.of((Object)new ValueMappingEntry(TRIVIAL, Integer.valueOf(5)), (Object)new ValueMappingEntry(MINOR, Integer.valueOf(4)), (Object)new ValueMappingEntry(MAJOR, Integer.valueOf(3)), (Object)new ValueMappingEntry(CRITICAL, Integer.valueOf(2)), (Object)new ValueMappingEntry(BLOCKER, Integer.valueOf(1)));
    }

    public boolean canBeBlank() {
        return false;
    }

    public boolean canBeCustom() {
        return true;
    }

    public boolean isMandatory() {
        return false;
    }
}

