/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.fetch;

import com.atlassian.jira.plugins.importer.bitbucket.fetch.FetchOneRepositoryProgress;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FetchSummaryProgress {
    private final AtomicReference<FetchOneRepositoryProgress> currentFetchProgressReference = new AtomicReference();
    private final AtomicInteger currentProjects = new AtomicInteger(0);
    private final int totalProjects;
    private volatile String error;

    public FetchSummaryProgress(int totalProjects) {
        this.totalProjects = totalProjects;
    }

    public void setNewFetchProgress(FetchOneRepositoryProgress currentFetchProgress) {
        this.currentFetchProgressReference.set(currentFetchProgress);
    }

    private void setOperationAddProgress(String currentOperation, int progressStep) {
        FetchOneRepositoryProgress newProgress;
        FetchOneRepositoryProgress oldProgress;
        while (!this.currentFetchProgressReference.compareAndSet(oldProgress = this.currentFetchProgressReference.get(), newProgress = new FetchOneRepositoryProgress(oldProgress.getRepositoryName(), oldProgress.getCurrentIssues() + progressStep, oldProgress.getTotalIssues(), currentOperation))) {
        }
    }

    public void setOperationIncProgress(String currentOperation) {
        this.setOperationAddProgress(currentOperation, 1);
    }

    public void setOperation(String currentOperation) {
        this.setOperationAddProgress(currentOperation, 0);
    }

    public void incCurrentProjects() {
        this.currentProjects.incrementAndGet();
    }

    public void setError(String error) {
        this.error = error;
    }

    public FetchOneRepositoryProgress getCurrentFetchProgress() {
        return this.currentFetchProgressReference.get();
    }

    public int getTotalProjects() {
        return this.totalProjects;
    }

    public String getError() {
        return this.error;
    }

    public int getCurrentProjects() {
        return this.currentProjects.get();
    }
}

