/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.fetch;

import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterClient;
import com.atlassian.jira.plugins.importer.bitbucket.fetch.FetchOneRepositoryProgress;
import com.atlassian.jira.plugins.importer.bitbucket.fetch.FetchSummaryProgress;
import com.atlassian.jira.plugins.importer.bitbucket.fetch.VoidOut;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.I18nHelper;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.Logger;

@ThreadSafe
public class DataFetchJob {
    private final Logger log = Logger.getLogger(this.getClass());
    private final BitbucketImporterClient client;
    private final I18nHelper i18nHelper;
    private volatile FetchSummaryProgress fetchProgress = new FetchSummaryProgress(0);
    private final AtomicBoolean working = new AtomicBoolean(false);
    private volatile TaskDescriptor<VoidOut> taskDescriptor;

    public DataFetchJob(BitbucketImporterClient client, I18nHelper i18nHelper) {
        this.client = client;
        this.i18nHelper = i18nHelper;
    }

    public void startFetching(TaskManager taskManager, List<String> selectedProjects) {
        if (this.working.compareAndSet(false, true)) {
            this.taskDescriptor = taskManager.submitTask((Callable)new DataFetchCallable(selectedProjects), "Bitbucket importer fetch data task", (TaskContext)new EmptyTaskContext(), true);
        }
    }

    public TaskDescriptor<VoidOut> getFetchingTask() {
        return this.taskDescriptor;
    }

    public FetchSummaryProgress getFetchProgress() {
        return this.fetchProgress;
    }

    private void setFetchProgress(FetchSummaryProgress fetchProgress) {
        this.fetchProgress = fetchProgress;
    }

    private static final class EmptyTaskContext
    implements TaskContext {
        private EmptyTaskContext() {
        }

        public String buildProgressURL(Long aLong) {
            return null;
        }
    }

    private class DataFetchCallable
    implements Callable<VoidOut> {
        private final List<String> selectedProjects;
        private final FetchSummaryProgress progress;

        private DataFetchCallable(List<String> selectedProjects) {
            this.selectedProjects = selectedProjects;
            this.progress = new FetchSummaryProgress(selectedProjects.size());
        }

        @Override
        public VoidOut call() throws Exception {
            try {
                DataFetchJob.this.client.clearProjects();
                DataFetchJob.this.setFetchProgress(this.progress);
                for (String projectName : this.selectedProjects) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    DataFetchJob.this.client.loadProject(projectName, new BitbucketImporterClient.ProgressFeedback(){

                        @Override
                        public void newProgress(FetchOneRepositoryProgress fetchOneRepositoryProgress) {
                            DataFetchJob.this.fetchProgress.setNewFetchProgress(fetchOneRepositoryProgress);
                        }

                        @Override
                        public void changeOperation(String currentOperation) {
                            DataFetchJob.this.fetchProgress.setOperation(currentOperation);
                        }

                        @Override
                        public void changeOperationAndIncreaseProgress(String currentOperation) {
                            DataFetchJob.this.fetchProgress.setOperationIncProgress(currentOperation);
                        }
                    });
                    DataFetchJob.this.fetchProgress.incCurrentProjects();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                DataFetchJob.this.fetchProgress.setError(DataFetchJob.this.i18nHelper.getText("com.atlassian.jira.plugins.importer.bitbucket.fetchData.interrupted"));
                DataFetchJob.this.log.info((Object)"Fetching data from Bitbucket has been canceled");
            }
            catch (Exception e) {
                DataFetchJob.this.fetchProgress.setError(DataFetchJob.this.i18nHelper.getText("com.atlassian.jira.plugins.importer.bitbucket.fetchData.unknown.exception", e.toString()));
                DataFetchJob.this.log.error((Object)"Fetching data from Bitbucket has failed", (Throwable)e);
            }
            finally {
                DataFetchJob.this.working.set(false);
            }
            return null;
        }
    }
}

