/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket.fetch;

import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackCompatibilityUtil {
    private static final Logger log = LoggerFactory.getLogger(BackCompatibilityUtil.class);

    public static void cancelTask(TaskDescriptor<?> taskDescriptor, TaskManager taskManager) {
        if (!BackCompatibilityUtil.tryToCancelTaskInJIRA61(taskDescriptor) && !BackCompatibilityUtil.tryToCancelTaskInJira63(taskDescriptor.getTaskId(), taskManager)) {
            log.warn("Cannot find a cancel method in TaskDescriptor, task was left uncancelled: " + taskDescriptor);
        }
    }

    private static boolean tryToCancelTaskInJIRA61(TaskDescriptor<?> taskDescriptor) {
        try {
            Method cancel = TaskDescriptor.class.getMethod("cancel", new Class[0]);
            cancel.invoke(taskDescriptor, new Object[0]);
            return true;
        }
        catch (NoSuchMethodException ignore) {
            return false;
        }
        catch (InvocationTargetException ignore) {
            return false;
        }
        catch (IllegalAccessException ignore) {
            return false;
        }
    }

    private static boolean tryToCancelTaskInJira63(Long id, TaskManager taskManager) {
        try {
            Method cancelTask = TaskManager.class.getMethod("cancelTask", Long.class);
            cancelTask.invoke((Object)taskManager, id);
            return true;
        }
        catch (NoSuchMethodException ignore) {
            return false;
        }
        catch (InvocationTargetException ignore) {
            return false;
        }
        catch (IllegalAccessException ignore) {
            return false;
        }
    }
}

