/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket;

import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImportProcessBean;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterClient;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterConfigBean;
import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterDataBean;
import com.atlassian.jira.plugins.importer.bitbucket.fetch.DataFetchJob;
import com.atlassian.jira.plugins.importer.bitbucket.web.ProjectMappingsPage;
import com.atlassian.jira.plugins.importer.bitbucket.web.SetupPage;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.web.AbstractImporterController;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.plugins.importer.web.ImporterFieldMappingsPage;
import com.atlassian.jira.plugins.importer.web.ImporterLinksPage;
import com.atlassian.jira.plugins.importer.web.ImporterValueMappingsPage;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class BitbucketImporterController
extends AbstractImporterController {
    private static final String IMPORT_SESSION_ATTRIBUTE_NAME = "issue.importer.jira.bitbucket.import.bean";
    private static final String IMPORT_ID = "BitbucketImporter";
    private final ConfigFileHandler configFileHandler;
    private final I18nHelper i18nHelper;

    public BitbucketImporterController(@ComponentImport JiraDataImporter importer, @ComponentImport ConfigFileHandler configFileHandler, @ComponentImport I18nHelper i18nHelper) {
        super(importer, IMPORT_SESSION_ATTRIBUTE_NAME, IMPORT_ID);
        this.configFileHandler = configFileHandler;
        this.i18nHelper = i18nHelper;
    }

    public boolean createImportProcessBean(AbstractSetupPage abstractSetupPage) {
        if (abstractSetupPage.invalidInput()) {
            return false;
        }
        SetupPage setupPage = (SetupPage)abstractSetupPage;
        BitbucketImporterClient client = new BitbucketImporterClient();
        DataFetchJob dataFetchJob = new DataFetchJob(client, this.i18nHelper);
        BitbucketImporterConfigBean configBean = new BitbucketImporterConfigBean(client);
        client.setConfig(configBean);
        if (!this.configFileHandler.populateFromConfigFile((AbstractSetupPage)setupPage, (AbstractConfigBean)configBean)) {
            return false;
        }
        BitbucketImportProcessBean importProcessBean = new BitbucketImportProcessBean(dataFetchJob);
        importProcessBean.setConfigBean((AbstractConfigBean)configBean);
        this.storeImportProcessBeanInSession(importProcessBean);
        return true;
    }

    public ImportDataBean createDataBean() throws Exception {
        BitbucketImportProcessBean importProcessBean = (BitbucketImportProcessBean)this.getImportProcessBeanFromSession();
        return new BitbucketImporterDataBean(importProcessBean);
    }

    public List<String> getSteps() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new String[]{SetupPage.class.getSimpleName(), ProjectMappingsPage.class.getSimpleName(), ImporterFieldMappingsPage.class.getSimpleName(), ImporterValueMappingsPage.class.getSimpleName(), ImporterLinksPage.class.getSimpleName()});
        return builder.build();
    }

    public List<String> getStepNameKeys() {
        return Lists.newArrayList((Object[])new String[]{"com.atlassian.jira.plugins.importer.bitbucket.step.setup", "com.atlassian.jira.plugins.importer.bitbucket.step.projectMapping", "com.atlassian.jira.plugins.importer.bitbucket.step.mapFields", "com.atlassian.jira.plugins.importer.bitbucket.step.mapValues", "com.atlassian.jira.plugins.importer.bitbucket.step.mapLinks"});
    }
}

