/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket;

import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterClient;
import com.atlassian.jira.plugins.importer.bitbucket.mapping.IssueTypeValueMappingDefinition;
import com.atlassian.jira.plugins.importer.bitbucket.mapping.PriorityValueMappingDefinition;
import com.atlassian.jira.plugins.importer.bitbucket.mapping.ResolutionValueMappingDefinition;
import com.atlassian.jira.plugins.importer.bitbucket.mapping.StatusValueMappingDefinition;
import com.atlassian.jira.plugins.importer.bitbucket.model.BitbucketLinkType;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinitionsFactory;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelper;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingHelperImpl;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class BitbucketImporterConfigBean
extends AbstractConfigBean2 {
    private final BitbucketImporterClient client;

    public BitbucketImporterConfigBean(BitbucketImporterClient client) {
        this.client = client;
        this.populateLinkMappings((Map)ImmutableMap.of((Object)BitbucketLinkType.DUPLICATE_LINK_NAME.getValue(), (Object)"Duplicate", (Object)BitbucketLinkType.MENTION_LINK_NAME.getValue(), (Object)"Relates"));
    }

    public List<String> getExternalProjectNames() {
        return Lists.newArrayList(this.client.getAllProjectNames());
    }

    public List<String> getSelectedProjects() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.getExternalProjectNames(), (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String projectName) {
                return BitbucketImporterConfigBean.this.isProjectSelected(projectName);
            }
        }));
    }

    public List<ExternalCustomField> getCustomFields() {
        return Collections.EMPTY_LIST;
    }

    public List<String> getLinkNamesFromDb() {
        return Lists.newArrayList((Iterable)Collections2.transform(Arrays.asList(BitbucketLinkType.values()), (Function)new Function<BitbucketLinkType, String>(){

            public String apply(BitbucketLinkType input) {
                return input.getValue();
            }
        }));
    }

    public ValueMappingHelper initializeValueMappingHelper() {
        ValueMappingDefinitionsFactory mappingDefinitionFactory = new ValueMappingDefinitionsFactory(){

            public List<ValueMappingDefinition> createMappingDefinitions(ValueMappingHelper valueMappingHelper) {
                ArrayList mappings = Lists.newArrayList();
                mappings.add(new IssueTypeValueMappingDefinition(BitbucketImporterConfigBean.this.getConstantsManager()));
                mappings.add(new StatusValueMappingDefinition(BitbucketImporterConfigBean.this));
                mappings.add(new ResolutionValueMappingDefinition(BitbucketImporterConfigBean.this.getConstantsManager()));
                mappings.add(new PriorityValueMappingDefinition(BitbucketImporterConfigBean.this.getConstantsManager()));
                return mappings;
            }
        };
        return new ValueMappingHelperImpl(this.getWorkflowSchemeManager(), this.getWorkflowManager(), mappingDefinitionFactory, this.getConstantsManager());
    }

    public BitbucketImporterClient getBitbucketImporterClient() {
        return this.client;
    }
}

