/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.bitbucket;

import com.atlassian.jira.plugins.importer.bitbucket.BitbucketImporterConfigBean;
import com.atlassian.jira.plugins.importer.bitbucket.fetch.FetchOneRepositoryProgress;
import com.atlassian.jira.plugins.importer.bitbucket.model.Attachment;
import com.atlassian.jira.plugins.importer.bitbucket.model.BitbucketLinkType;
import com.atlassian.jira.plugins.importer.bitbucket.model.Comment;
import com.atlassian.jira.plugins.importer.bitbucket.model.CurrentUserData;
import com.atlassian.jira.plugins.importer.bitbucket.model.Issue;
import com.atlassian.jira.plugins.importer.bitbucket.model.Project;
import com.atlassian.jira.plugins.importer.bitbucket.model.RepositoryExportStatus;
import com.atlassian.jira.plugins.importer.bitbucket.model.User;
import com.atlassian.jira.plugins.importer.bitbucket.scribe.DoWithSalCallback;
import com.atlassian.jira.plugins.importer.bitbucket.transformer.ComponentTransformer;
import com.atlassian.jira.plugins.importer.bitbucket.transformer.IssueTransformer;
import com.atlassian.jira.plugins.importer.bitbucket.transformer.ProjectTransformer;
import com.atlassian.jira.plugins.importer.bitbucket.transformer.UserTransformer;
import com.atlassian.jira.plugins.importer.bitbucket.transformer.VersionTransformer;
import com.atlassian.jira.plugins.importer.external.beans.ExternalComponent;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.external.beans.ExternalUser;
import com.atlassian.jira.plugins.importer.external.beans.ExternalVersion;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.scribe.model.OAuthRequest;
import org.scribe.model.SalOAuthRequest;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuthService;

public class BitbucketImporterClient {
    private final Logger log = Logger.getLogger(this.getClass());
    private final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final Duration PREPARE_BACKUP_TIMEOUT = Duration.standardMinutes((long)10L);
    private static final int NUMBER_OF_EXTRA_STEPS_IN_PROGRESSBAR = 3;
    private static final int BUF_SIZE = 4096;
    private final Map<String, Project> bitbucketProjects = Collections.synchronizedMap(new HashMap());
    private CurrentUserData currentUserData;
    private BitbucketImporterConfigBean config;
    private OAuthService service;
    private Token accessToken;
    private final List<File> tmpFiles = Collections.synchronizedList(new LinkedList());
    private final Pattern mentionIssuePattern = Pattern.compile("#(\\d+)");
    private final Pattern duplicateIssuePattern = Pattern.compile("Duplicate of #(\\d+)");

    private static String printableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] measureUnuts = new String[]{"bytes", "KB", "MB", "GB", "TB"};
        int groups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, groups)) + " " + measureUnuts[groups];
    }

    public synchronized void loadCurrentUserData() {
        SalOAuthRequest request = new SalOAuthRequest(Verb.GET, "https://bitbucket.org/api/1.0/user/");
        this.service.signRequest(this.accessToken, (OAuthRequest)request);
        final String username = request.sendViaSal(new DoWithSalCallback<String>(){

            @Override
            protected String afterHandleResponse(Response response) throws ResponseException {
                try {
                    return Project.Parser.parseCurrentUserData(response.getResponseBodyAsStream());
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        request = new SalOAuthRequest(Verb.GET, "https://bitbucket.org/api/1.0/user/repositories");
        this.service.signRequest(this.accessToken, (OAuthRequest)request);
        List<String> visibleRepositories = request.sendViaSal(new DoWithSalCallback<List<String>>(){

            @Override
            protected List<String> afterHandleResponse(Response response) throws ResponseException {
                try {
                    return Project.Parser.parseVisibleRepositories(response.getResponseBodyAsStream(), username);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        this.currentUserData = new CurrentUserData(username, visibleRepositories);
    }

    public synchronized Collection<String> getAllProjectNames() {
        return this.currentUserData.getRepositoriesNames();
    }

    public boolean isAdminOnRepo(String userSlashRepo) {
        SalOAuthRequest request = new SalOAuthRequest(Verb.GET, "https://bitbucket.org/api/1.0/privileges/" + userSlashRepo);
        this.service.signRequest(this.accessToken, (OAuthRequest)request);
        return request.sendViaSal(new DoWithSalCallback<Boolean>(){

            @Override
            protected Boolean afterHandleResponse(Response response) throws ResponseException {
                return response.getStatusCode() < 400;
            }
        });
    }

    public Collection<ExternalProject> getAllProjects(ImportLogger log) {
        return Collections2.transform(this.bitbucketProjects.values(), (Function)new ProjectTransformer(this.config));
    }

    public Collection<ExternalVersion> getVersions(String projectId, ImportLogger log) {
        Project project = this.getProjectById(projectId);
        return Collections2.transform((Collection)Sets.union(project.getVersions(), project.getMilestones()), (Function)new VersionTransformer());
    }

    public Collection<ExternalComponent> getComponents(String projectId, ImportLogger log) {
        return Collections2.transform(this.getProjectById(projectId).getComponents(), (Function)new ComponentTransformer());
    }

    public Collection<ExternalUser> getUsers() {
        Collection allUsersCollection = Collections2.transform(this.bitbucketProjects.values(), (Function)new Function<Project, Set<User>>(){

            public Set<User> apply(Project input) {
                return input.getUsers();
            }
        });
        Iterator usersSetsIterator = allUsersCollection.iterator();
        if (!usersSetsIterator.hasNext()) {
            return Collections.emptyList();
        }
        Set combinedSet = (Set)usersSetsIterator.next();
        while (usersSetsIterator.hasNext()) {
            combinedSet = Sets.union((Set)((Set)usersSetsIterator.next()), (Set)combinedSet);
        }
        return Collections2.transform((Collection)combinedSet, (Function)new UserTransformer());
    }

    public Iterator<ExternalIssue> getIssuesIterator(ExternalProject externalProject, ImportLogger importLogger) {
        Project project = this.bitbucketProjects.get(externalProject.getId());
        List<Issue> issues = project.getIssues();
        Collections.sort(issues, new Comparator<Issue>(){

            @Override
            public int compare(Issue o1, Issue o2) {
                int y;
                int x = o1.getId();
                return x < (y = o2.getId()) ? -1 : (x == y ? 0 : 1);
            }
        });
        return Collections2.transform(issues, (Function)new IssueTransformer(project.getComments(), project.getAttachments(), this.config, importLogger)).iterator();
    }

    public Collection<ExternalLink> getLinks(Collection<ExternalProject> projects, ImportLogger log) {
        String duplicateMapping = this.config.getLinkMapping(BitbucketLinkType.DUPLICATE_LINK_NAME.getValue());
        String mentionsMapping = this.config.getLinkMapping(BitbucketLinkType.MENTION_LINK_NAME.getValue());
        ArrayList result = Lists.newArrayList();
        for (ExternalProject externalProject : projects) {
            Project project = this.bitbucketProjects.get(externalProject.getId());
            for (Comment comment : project.getComments()) {
                Matcher duplicatedIssueMatcher = this.duplicateIssuePattern.matcher(comment.getContent());
                while (duplicatedIssueMatcher.find()) {
                    int linkedIssueId = Integer.parseInt(duplicatedIssueMatcher.group(1));
                    result.add(new ExternalLink(duplicateMapping, Integer.toString(comment.getIssue()), Integer.toString(linkedIssueId)));
                }
                Matcher mentionedIssueMatcher = this.mentionIssuePattern.matcher(duplicatedIssueMatcher.replaceAll(""));
                while (mentionedIssueMatcher.find()) {
                    int linkedIssueId = Integer.parseInt(mentionedIssueMatcher.group(1));
                    result.add(new ExternalLink(mentionsMapping, Integer.toString(comment.getIssue()), Integer.toString(linkedIssueId)));
                }
            }
        }
        return result;
    }

    public long getTotalIssues(Set<ExternalProject> selectedProjects, ImportLogger importLogger) {
        long total = 0L;
        for (ExternalProject externalProject : selectedProjects) {
            Project project = this.bitbucketProjects.get(externalProject.getId());
            total += (long)project.getIssues().size();
        }
        return total;
    }

    public void setConfig(BitbucketImporterConfigBean config) {
        this.config = config;
    }

    public void setAccessToken(Token accessToken) {
        this.accessToken = accessToken;
    }

    public OAuthService getService() {
        return this.service;
    }

    public void setService(OAuthService service) {
        this.service = service;
    }

    public void clearProjects() {
        this.bitbucketProjects.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        List<File> list = this.tmpFiles;
        synchronized (list) {
            Iterator<File> i = this.tmpFiles.iterator();
            while (i.hasNext()) {
                File toRemove = i.next();
                toRemove.delete();
                i.remove();
            }
        }
    }

    public void loadProject(String projectName, ProgressFeedback progressFeedback) throws IOException, InterruptedException {
        if (this.bitbucketProjects.containsKey(projectName)) {
            throw new IllegalStateException("Fetching project '" + projectName + "' that is already fetched...");
        }
        this.startRepositoryBackup(projectName, progressFeedback);
        String fetchAddress = this.waitForRepositoryBackupToFinish(projectName, progressFeedback);
        File projectFile = this.downloadRepositoryBackup(projectName, fetchAddress, progressFeedback);
        Project project = this.parseProjectFile(projectName, projectFile, progressFeedback);
        this.extractProjectAttachments(project, projectFile, progressFeedback);
        this.bitbucketProjects.put(projectName, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractProjectAttachments(Project project, File projectFile, ProgressFeedback progressFeedback) throws IOException {
        progressFeedback.changeOperationAndIncreaseProgress("extracting attachments");
        ZipFile zipFile = new ZipFile(projectFile);
        try {
            for (Attachment attachment : project.getAttachments()) {
                progressFeedback.changeOperation("extracting attachments (" + attachment.getIssue() + "-" + attachment.getFilename() + ")");
                ZipEntry entry = zipFile.getEntry(attachment.getPath());
                InputStream in = zipFile.getInputStream(entry);
                try {
                    File attachmentFile = this.getTempFile(project.getName() + "-" + attachment.getFilename());
                    FileOutputStream out = new FileOutputStream(attachmentFile);
                    try {
                        ByteStreams.copy((InputStream)in, (OutputStream)out);
                        attachment.setTmpFile(attachmentFile);
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                finally {
                    in.close();
                }
            }
        }
        finally {
            zipFile.close();
        }
    }

    private void startRepositoryBackup(String projectName, ProgressFeedback progressFeedback) {
        if (this.service == null || this.accessToken == null) {
            throw new IllegalStateException("accessToken has not been set");
        }
        progressFeedback.newProgress(new FetchOneRepositoryProgress(projectName, 0, 0, "requesting backup of repository"));
        SalOAuthRequest request = new SalOAuthRequest(Verb.POST, "https://bitbucket.org/api/1.0/repositories/" + projectName + "/issues/export");
        this.service.signRequest(this.accessToken, (OAuthRequest)request);
        Integer statusCode = request.sendViaSal(new DoWithSalCallback<Integer>(){

            @Override
            protected Integer afterHandleResponse(Response response) throws ResponseException {
                return response.getStatusCode();
            }
        });
        if (!statusCode.equals(new Integer(202))) {
            throw new IllegalStateException("Couldn't start backup of project: " + projectName);
        }
    }

    private String waitForRepositoryBackupToFinish(String projectName, ProgressFeedback progressFeedback) throws InterruptedException, UnsupportedEncodingException {
        if (this.service == null || this.accessToken == null) {
            throw new IllegalStateException("accessToken has not been set");
        }
        DateTime startOfBackup = DateTime.now();
        do {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            SalOAuthRequest request = new SalOAuthRequest(Verb.GET, "https://bitbucket.org/api/1.0/repositories/" + projectName + "/issues/export");
            this.service.signRequest(this.accessToken, (OAuthRequest)request);
            RepositoryExportStatus status = request.sendViaSal(new DoWithSalCallback<RepositoryExportStatus>(){

                @Override
                protected RepositoryExportStatus afterHandleResponse(Response response) throws ResponseException {
                    try {
                        return Project.Parser.parseRepositoryExportStatus(response.getResponseBodyAsStream());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalStateException(e);
                    }
                }
            });
            if ("ACCEPTED".equals(status.getStatus())) {
                if (status.getCount() != null) {
                    progressFeedback.newProgress(new FetchOneRepositoryProgress(projectName, Integer.parseInt(status.getCount()), Integer.parseInt(status.getTotal()) + 3, status.getPhase()));
                }
            } else {
                if ("SUCCESS".equals(status.getStatus())) {
                    return "https://bitbucket.org" + status.getUrl();
                }
                throw new IllegalStateException("Unrecognized status: " + status.getStatus());
            }
            Thread.sleep(100L);
        } while (!DateTime.now().isAfter((ReadableInstant)startOfBackup.withDurationAdded((ReadableDuration)PREPARE_BACKUP_TIMEOUT, 1)));
        throw new IllegalStateException("Backup preparation timeout!");
    }

    private File getTempFile(String namePart) throws IOException {
        String filename = "jira-bitbucket-import-" + namePart.replaceAll("/", "_") + "-";
        filename = this.sanitizeFilename(filename);
        this.log.debug((Object)("Creating temp file: " + filename));
        File file = File.createTempFile(filename, ".tmp", AttachmentUtils.getTemporaryAttachmentDirectory());
        this.tmpFiles.add(file);
        if (file.getParentFile() != null) {
            FileUtils.forceMkdir((File)file.getParentFile());
        }
        return file;
    }

    private String sanitizeFilename(String filename) {
        if (this.isWindowsOs() && (filename = filename.replaceAll("[:\\\\/*?|<>]", "_")).length() >= 255) {
            this.log.debug((Object)("Filename ' " + filename + " ' too long, abbreviating ..."));
            filename = filename.substring(0, 255);
        }
        return filename;
    }

    private boolean isWindowsOs() {
        return this.OS_NAME.indexOf("windows") > -1;
    }

    private File downloadRepositoryBackup(final String projectName, String fetchAddress, final ProgressFeedback progressFeedback) {
        progressFeedback.changeOperationAndIncreaseProgress("downloading repository export file");
        SalOAuthRequest request = new SalOAuthRequest(Verb.GET, fetchAddress);
        this.service.signRequest(this.accessToken, (OAuthRequest)request);
        return request.sendViaSal(new DoWithSalCallback<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected File afterHandleResponse(Response response) throws ResponseException {
                InputStream in = response.getResponseBodyAsStream();
                try {
                    File file;
                    File outFile = BitbucketImporterClient.this.getTempFile(projectName);
                    FileOutputStream out = new FileOutputStream(outFile);
                    try {
                        int r;
                        byte[] buf = new byte[4096];
                        long total = 0L;
                        while ((r = in.read(buf)) != -1) {
                            ((OutputStream)out).write(buf, 0, r);
                            progressFeedback.changeOperation("downloading repository export file: " + BitbucketImporterClient.printableFileSize(total += (long)r));
                        }
                        file = outFile;
                    }
                    catch (Throwable throwable) {
                        try {
                            ((OutputStream)out).close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    ((OutputStream)out).close();
                    return file;
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Project parseProjectFile(String projectName, File projectFile, ProgressFeedback progressFeedback) throws IOException {
        ZipEntry entry;
        progressFeedback.changeOperationAndIncreaseProgress("parsing repository file");
        ZipInputStream in = new ZipInputStream(new FileInputStream(projectFile));
        while (!"db-1.0.json".equals((entry = in.getNextEntry()).getName()) && entry != null) {
        }
        if (entry == null) {
            in.close();
            throw new FileNotFoundException("Provided input stream didn't have zip packed db-1.0.json file");
        }
        try {
            Project project = Project.Parser.parseProject(projectName, in);
            return project;
        }
        finally {
            try {
                in.closeEntry();
            }
            finally {
                in.close();
            }
        }
    }

    private Project getProjectById(String projectId) {
        return this.bitbucketProjects.get(projectId);
    }

    public static interface ProgressFeedback {
        public void newProgress(FetchOneRepositoryProgress var1);

        public void changeOperation(String var1);

        public void changeOperationAndIncreaseProgress(String var1);
    }
}

