/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.asana.web;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Strings;

public class AsanaSetupPage
extends AbstractSetupPage {
    private String asanaApiKey = "";

    public AsanaSetupPage(@ComponentImport UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport EventPublisher eventPublisher) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, eventPublisher);
    }

    public String doDefault() throws Exception {
        if (!this.isAdministrator()) {
            return "denied";
        }
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        return "input";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        if (this.hasAnyErrors()) {
            return "input";
        }
        if (!this.isPreviousClicked() && !controller.createImportProcessBean((AbstractSetupPage)this)) {
            return "input";
        }
        return super.doExecute();
    }

    protected void doValidation() {
        if (!this.isPreviousClicked() && Strings.isNullOrEmpty((String)this.asanaApiKey)) {
            this.addErrorMessage(this.getText("com.atlassian.jira.plugins.importer.asana.setuppage.apikey.missing"));
        }
        super.doValidation();
    }

    public String getAsanaApiKey() {
        return this.asanaApiKey;
    }

    public void setAsanaApiKey(String asanaApiKey) {
        this.asanaApiKey = asanaApiKey;
    }
}

