/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.asana.transformers;

import com.atlassian.fugue.Options;
import com.atlassian.jira.plugins.importer.asana.AsanaConfigBean;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Heart;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Story;
import com.atlassian.jira.plugins.importer.asana.rest.beans.Task;
import com.atlassian.jira.plugins.importer.asana.rest.beans.User;
import com.atlassian.jira.plugins.importer.asana.transformers.AttachmentTransformer;
import com.atlassian.jira.plugins.importer.asana.transformers.StoryTransformer;
import com.atlassian.jira.plugins.importer.asana.transformers.TagTransformer;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.external.beans.ExternalLink;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class TaskTransformer
implements Function<Task, ExternalIssue> {
    private final Logger log = Logger.getLogger(this.getClass());
    public static final String UNNAMED_TASK = "(unnamed task)";
    private final AsanaConfigBean configBean;
    private final ImportLogger importLogger;
    private final Long projectId;

    public TaskTransformer(AsanaConfigBean configBean, long projectId, ImportLogger importLogger) {
        this.configBean = configBean;
        this.projectId = projectId;
        this.importLogger = importLogger;
    }

    public ExternalIssue apply(Task task) {
        String subtaskLinkName;
        ExternalIssue externalIssue = new ExternalIssue();
        externalIssue.setSummary(task.getName());
        if (Strings.isNullOrEmpty((String)task.getName())) {
            externalIssue.setSummary(UNNAMED_TASK);
            this.importLogger.warn("No summary for task with external ID %s ; task imported with summary \"%s\" instead.", new Object[]{this.createExternalId(task.getId(), this.projectId), UNNAMED_TASK});
        }
        this.handleDescriptionField(externalIssue, task.getNotes());
        if (task.getAssignee() != null && task.getAssignee().getEmail() != null) {
            externalIssue.setAssignee(task.getAssignee().getEmail());
        }
        externalIssue.setCreated(task.getCreated_at());
        externalIssue.setReporter(task.getCreated_by().getEmail());
        externalIssue.setDuedate(task.getDue_at());
        externalIssue.setResolutionDate(task.getCompleted_at());
        externalIssue.setIssueType("Task");
        this.handleVoters(externalIssue, task);
        externalIssue.setWatchers(new ArrayList(Collections2.transform(task.getFollowers(), (Function)new Function<User, String>(){

            public String apply(User user) {
                return user.getEmail();
            }
        })));
        Collection comments = Collections2.filter(task.getStories(), (Predicate)new Predicate<Story>(){

            public boolean apply(Story story) {
                return story.getType().equals("comment");
            }
        });
        externalIssue.setComments(Collections2.transform((Collection)comments, (Function)new StoryTransformer()));
        Iterable existingAttachents = Options.flatten((Iterable)Iterables.transform(task.getAttachments(), (Function)new AttachmentTransformer(this.importLogger)));
        externalIssue.setAttachments((List)ImmutableList.copyOf((Iterable)existingAttachents));
        externalIssue.setLabels(Collections2.transform(task.getTags(), (Function)new TagTransformer()));
        externalIssue.setStatus(task.isCompleted() != false ? this.configBean.getValueMappingHelper().getValueMapping("completed", "Completed") : this.configBean.getValueMappingHelper().getValueMapping("completed", "Incomplete"));
        externalIssue.setResolution(task.isCompleted() != false ? "Fixed" : null);
        externalIssue.setExternalId(this.createExternalId(task.getId(), this.projectId));
        externalIssue.setPriority(this.configBean.getValueMappingHelper().getValueMapping("assignee_status", task.getAssignee_status()));
        if (task.getParent() != null && !Strings.isNullOrEmpty((String)(subtaskLinkName = this.configBean.getLinkMapping("Subtask")))) {
            this.configBean.getSubtaskLinks().add(new ExternalLink(subtaskLinkName, this.createExternalId(task.getId(), this.projectId), this.createExternalId(task.getParent().getId(), this.projectId)));
        }
        return externalIssue;
    }

    private void handleVoters(ExternalIssue externalIssue, Task task) {
        ImmutableList.Builder heartEmails = ImmutableList.builder();
        List<Heart> hearts = task.getHearts();
        if (hearts == null) {
            return;
        }
        for (Heart heart : hearts) {
            String email = heart.getUser().getEmail();
            if (!Strings.isNullOrEmpty((String)email)) {
                heartEmails.add((Object)email);
                continue;
            }
            this.log.warn((Object)("Skipping heart from user " + heart.getUser() + ". Reason: no email defined"));
        }
        externalIssue.setVoters((Collection)heartEmails.build());
    }

    private void handleDescriptionField(ExternalIssue externalIssue, String notes) {
        if (this.configBean.isFieldMappedToIssueField("notes")) {
            externalIssue.setDescription(notes);
        } else {
            String customFieldName = this.configBean.getFieldMapping("notes");
            ExternalCustomField notesCustomField = this.configBean.getDefaultNotesCustomField();
            externalIssue.addExternalCustomFieldValue(new ExternalCustomFieldValue(customFieldName, notesCustomField.getTypeKey(), notesCustomField.getSearcherKey(), (Object)notes));
        }
    }

    private String createExternalId(Long taskId, Long projectId) {
        return taskId.toString() + "/" + projectId.toString();
    }
}

