/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.asana.mapping;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.importer.asana.AsanaConfigBean;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingDefinition;
import com.atlassian.jira.plugins.importer.imports.config.ValueMappingEntry;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;

public class StatusValueMappingDefinition
implements ValueMappingDefinition {
    private final AsanaConfigBean configBean;

    public StatusValueMappingDefinition(AsanaConfigBean configBean) {
        this.configBean = configBean;
    }

    public String getExternalFieldId() {
        return "completed";
    }

    @Nullable
    public String getDescription() {
        return "";
    }

    @Nullable
    public Set<String> getDistinctValues() {
        return ImmutableSet.of((Object)"Incomplete", (Object)"Completed");
    }

    @Nullable
    public String getJiraFieldId() {
        return "status";
    }

    @Nullable
    public Collection<ValueMappingEntry> getTargetValues() {
        return Collections2.transform(this.getPossibleStatuses(), (Function)new Function<Status, ValueMappingEntry>(){

            public ValueMappingEntry apply(Status input) {
                return new ValueMappingEntry(input.getName(), input.getId());
            }
        });
    }

    public Collection<ValueMappingEntry> getDefaultValues() {
        Collection<Status> statuses = this.getPossibleStatuses();
        String toDo = this.byCategory(statuses, "new");
        String complete = this.byCategory(statuses, "done");
        return ImmutableList.of((Object)new ValueMappingEntry("Incomplete", toDo), (Object)new ValueMappingEntry("Completed", complete));
    }

    public boolean canBeBlank() {
        return false;
    }

    public boolean canBeImportedAsIs() {
        return false;
    }

    public boolean canBeCustom() {
        return false;
    }

    public boolean isMandatory() {
        return true;
    }

    private Collection<Status> getPossibleStatuses() {
        final WorkflowSchemeManager workflowSchemeManager = ComponentAccessor.getWorkflowSchemeManager();
        final WorkflowManager workflowManager = ComponentAccessor.getWorkflowManager();
        final ProjectManager projectManager = ComponentAccessor.getProjectManager();
        ImmutableSet workflows = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.filter((Iterable)Iterables.transform(this.configBean.getExternalProjectNames(), (Function)new Function<String, Collection<String>>(){

            public Collection<String> apply(String input) {
                if (!StatusValueMappingDefinition.this.configBean.isProjectSelected(input)) {
                    return null;
                }
                Project project = projectManager.getProjectObjByKey(StatusValueMappingDefinition.this.configBean.getProjectKey(input));
                if (project != null) {
                    return workflowSchemeManager.getWorkflowSchemeObj(project).getMappings().values();
                }
                return workflowSchemeManager.getDefaultWorkflowScheme().getMappings().values();
            }
        }), (Predicate)Predicates.notNull())));
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)workflows, (Function)new Function<String, Collection<Status>>(){

            public Collection<Status> apply(String input) {
                JiraWorkflow workflow = workflowManager.getWorkflow(input);
                return workflow.getLinkedStatusObjects();
            }
        })));
    }

    private String byCategory(Collection<Status> statuses, final String category) {
        ImmutableList byCategory = ImmutableList.copyOf((Iterable)Iterables.filter(statuses, (Predicate)new Predicate<Status>(){

            public boolean apply(Status input) {
                return input.getStatusCategory().getKey().equals(category);
            }
        }));
        if (byCategory.isEmpty()) {
            return statuses.isEmpty() ? "Open" : statuses.iterator().next().getId();
        }
        return ((Status)byCategory.iterator().next()).getId();
    }
}

