/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.asana;

import com.atlassian.jira.plugins.importer.asana.AsanaConfigBean;
import com.atlassian.jira.plugins.importer.asana.SinglePageTaskIterator;
import com.atlassian.jira.plugins.importer.asana.rest.PagedResult;
import com.atlassian.jira.plugins.importer.asana.rest.beans.collections.Tasks;
import com.atlassian.jira.plugins.importer.asana.transformers.TaskTransformer;
import com.atlassian.jira.plugins.importer.external.beans.ExternalIssue;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractMultiPageTaskIterator
implements Iterator<ExternalIssue> {
    private final TaskTransformer taskTransformer;
    private final AsanaConfigBean configBean;
    private final ImportLogger importLogger;
    private String offset;
    private boolean hasNextPage;
    private SinglePageTaskIterator currentPage;

    public AbstractMultiPageTaskIterator(long projectId, AsanaConfigBean asanaConfigBean, ImportLogger importLogger) {
        this.configBean = asanaConfigBean;
        this.importLogger = importLogger;
        this.taskTransformer = this.getTaskTransformer(projectId, importLogger);
    }

    @VisibleForTesting
    protected TaskTransformer getTaskTransformer(long projectId, ImportLogger importLogger) {
        return new TaskTransformer(this.configBean, projectId, importLogger);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.currentPage == null || this.hasNextPage && !this.currentPage.hasNext()) {
            this.loadNextPage();
        }
        return this.currentPage.hasNext();
    }

    @Override
    public ExternalIssue next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentPage.next();
    }

    private void loadNextPage() {
        PagedResult<Tasks> taskList = this.getNextTasks(this.offset);
        this.currentPage = new SinglePageTaskIterator(taskList.getData(), this.configBean, this.taskTransformer, this.importLogger);
        if (this.currentPage.hasNext()) {
            if (taskList.getNext_page() != null) {
                this.offset = taskList.getNext_page().getOffset();
                this.hasNextPage = true;
            } else {
                this.hasNextPage = false;
            }
        } else if (taskList.getNext_page() != null) {
            this.offset = taskList.getNext_page().getOffset();
            this.loadNextPage();
        } else {
            this.currentPage = new SinglePageTaskIterator(new Tasks(), this.configBean, this.taskTransformer, this.importLogger);
            this.hasNextPage = false;
        }
    }

    protected abstract PagedResult<Tasks> getNextTasks(String var1);
}

