/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.extra.icalfeed.service;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.extra.icalfeed.dateprovider.DateProvider;
import com.atlassian.jira.extra.icalfeed.dateprovider.DateProviderModuleDescriptor;
import com.atlassian.jira.extra.icalfeed.service.EntityAsEventService;
import com.atlassian.jira.extra.icalfeed.util.QueryUtil;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEntityAsEventService
implements EntityAsEventService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEntityAsEventService.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final FieldManager fieldManager;
    private final Collection<DateProvider> builtInProviders;
    private final DateProvider customFieldDateProvider;
    private final PluginAccessor pluginAccessor;
    private final SearchService searchService;
    private final QueryUtil queryUtil;
    private final ApplicationProperties applicationProperties;
    private final Map<String, EntityAsEventService.DurationReinterpreter> durationReinterpretersMap;

    public DefaultEntityAsEventService(JiraAuthenticationContext jiraAuthenticationContext, FieldManager fieldManager, Collection<DateProvider> builtInProviders, DateProvider customFieldDateProvider, PluginAccessor pluginAccessor, SearchService searchService, QueryUtil queryUtil, ApplicationProperties applicationProperties) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.fieldManager = fieldManager;
        this.builtInProviders = builtInProviders;
        this.customFieldDateProvider = customFieldDateProvider;
        this.pluginAccessor = pluginAccessor;
        this.searchService = searchService;
        this.queryUtil = queryUtil;
        this.applicationProperties = applicationProperties;
        this.durationReinterpretersMap = Collections.unmodifiableMap(new HashMap<String, EntityAsEventService.DurationReinterpreter>(){
            {
                this.put("created-duedate", new EntityAsEventService.DurationReinterpreter(){

                    @Override
                    public DateTime reinterpretStartDate(DateTime start, DateTime end) {
                        return start;
                    }

                    @Override
                    public DateTime reinterpretEndDate(DateTime start, DateTime end) {
                        if (this.isSameDayButBefore(start, end)) {
                            return end.withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59).withMillisOfSecond(999);
                        }
                        return end;
                    }

                    private boolean isSameDayButBefore(DateTime start, DateTime end) {
                        return start != null && end != null && start.getYear() == end.getYear() && start.getMonthOfYear() == end.getMonthOfYear() && start.getDayOfMonth() == end.getDayOfMonth() && start.isAfter((ReadableInstant)end);
                    }
                });
            }
        });
    }

    @Override
    public EntityAsEventService.Result search(Query query, Collection<String> dateFieldNames, Collection<EntityAsEventService.Duration> durations, boolean includeFixVersions, ApplicationUser user, long start, long end, int maxIssue) throws SearchException, ParseException {
        Map<Field, DateProvider> fieldToDateProviders = this.getFieldToDateProviderMap(dateFieldNames);
        Map<EntityAsEventService.Duration, DurationDateProviders> durationToDateProviders = this.getDurationToDateProviders(durations);
        Query originalQuery = query;
        query = this.queryUtil.getQueryWithDateFieldsOptimised(query, dateFieldNames, durations, start, end);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Original query: %s\nRewritten query: %s", originalQuery, query));
        }
        int maxFilter = maxIssue > 0 ? maxIssue : Integer.parseInt(this.applicationProperties.getDefaultBackedString("jira.search.views.default.max"));
        List issueResults = this.searchService.search(user, query, new PagerFilter(maxFilter)).getIssues();
        ArrayList<EntityAsEventService.IssueDateResult> issueDateResults = new ArrayList<EntityAsEventService.IssueDateResult>();
        I18nHelper i18nHelper = this.jiraAuthenticationContext.getI18nHelper();
        for (Issue issue : issueResults) {
            this.populateSingleDatesForIssue(issue, fieldToDateProviders, i18nHelper, issueDateResults);
            this.populateDurationsForIssue(issue, durationToDateProviders, i18nHelper, issueDateResults);
        }
        return new EntityAsEventService.Result(issueDateResults, Collections.emptySet(), includeFixVersions ? this.getVersionsFromQuery(query, user) : Collections.emptySet());
    }

    private void populateDurationsForIssue(Issue issue, Map<EntityAsEventService.Duration, DurationDateProviders> durationToDateProviders, I18nHelper i18nHelper, Collection<EntityAsEventService.IssueDateResult> issueDateResults) {
        for (Map.Entry<EntityAsEventService.Duration, DurationDateProviders> durationToDateProvidersEntry : durationToDateProviders.entrySet()) {
            boolean allDay;
            DurationDateProviders durationDatesProvider = durationToDateProvidersEntry.getValue();
            DateProvider startDateProvider = durationDatesProvider.getStartDateProvider();
            DateProvider endDateProvider = durationDatesProvider.getEndDateProvider();
            if (null == startDateProvider || null == endDateProvider) continue;
            Field startField = durationDatesProvider.getStartDateField();
            Field endField = durationDatesProvider.getEndDateField();
            LOG.debug(String.format("Start date provider (%s) : %s; End date provider (%s) : %s", startField, startDateProvider.getClass().getName(), endField, endDateProvider.getClass().getName()));
            DateTime startDate = startDateProvider.getStart(issue, startField);
            DateTime endDate = endDateProvider.getStart(issue, endField);
            EntityAsEventService.DurationReinterpreter durationReinterpreter = this.durationReinterpretersMap.get(startField.getId() + "-" + endField.getId());
            if (durationReinterpreter != null) {
                startDate = durationReinterpreter.reinterpretStartDate(startDate, endDate);
                endDate = durationReinterpreter.reinterpretEndDate(startDate, endDate);
            }
            LOG.debug(String.format("Duration fields: %s = %s; %s = %s.", startField.getId(), startDate, endField.getId(), endDate));
            if (null == startDate || null == endDate || startDate.isAfter((ReadableInstant)endDate)) continue;
            boolean bl = allDay = startDateProvider.isAllDay(issue, startField) && endDateProvider.isAllDay(issue, endField);
            if (allDay) {
                endDate = endDate.plusDays(1);
            }
            IssueType issueType = issue.getIssueTypeObject();
            Status issueStatus = issue.getStatusObject();
            issueDateResults.add(new EntityAsEventService.DurationIssueResult(issue.getAssignee(), allDay, issue.getKey(), issue.getSummary(), issue.getDescription(), issueType.getNameTranslation(i18nHelper), issueType.getIconUrl(), issueStatus.getNameTranslation(i18nHelper), this.getResolution(issue), issueStatus.getIconUrl(), new DateTime(issue.getCreated().getTime()), new DateTime(issue.getUpdated().getTime()), startDate, endDate, startField.getId(), startField.getName(), endField.getId(), endField.getName()));
        }
    }

    private String getResolution(Issue issue) {
        Resolution resolutionObject = issue.getResolutionObject();
        return resolutionObject == null ? null : resolutionObject.getName();
    }

    private void populateSingleDatesForIssue(Issue issue, Map<Field, DateProvider> fieldToDateProviders, I18nHelper i18nHelper, Collection<EntityAsEventService.IssueDateResult> issueDateResults) {
        for (Map.Entry<Field, DateProvider> singleDateFieldProviderEntry : fieldToDateProviders.entrySet()) {
            DateProvider singleDateFieldProvider = singleDateFieldProviderEntry.getValue();
            if (null == singleDateFieldProvider) continue;
            Field dateField = singleDateFieldProviderEntry.getKey();
            DateTime start = singleDateFieldProvider.getStart(issue, dateField);
            DateTime end = singleDateFieldProvider.getEnd(issue, dateField, start);
            if (null == start || null == end) continue;
            IssueType issueType = issue.getIssueTypeObject();
            Status issueStatus = issue.getStatusObject();
            issueDateResults.add(new EntityAsEventService.SingleDateIssueResult(issue.getAssignee(), singleDateFieldProvider.isAllDay(issue, dateField), issue.getKey(), issue.getSummary(), issue.getDescription(), issueType.getNameTranslation(i18nHelper), issueType.getIconUrl(), issueStatus.getNameTranslation(i18nHelper), this.getResolution(issue), issueStatus.getIconUrl(), new DateTime(issue.getCreated().getTime()), new DateTime(issue.getUpdated().getTime()), start, end, dateField.getId(), dateField.getName()));
        }
    }

    private Map<EntityAsEventService.Duration, DurationDateProviders> getDurationToDateProviders(Collection<EntityAsEventService.Duration> durations) {
        HashMap<EntityAsEventService.Duration, DurationDateProviders> durationToDateProviders = new HashMap<EntityAsEventService.Duration, DurationDateProviders>();
        if (null != durations) {
            for (EntityAsEventService.Duration duration : durations) {
                Field startDateField = this.fieldManager.getField(StringUtils.defaultString(duration.getStartDateFieldKey()));
                DateProvider startDateProvider = this.getFirstDateProviderForField(startDateField);
                Field endDateField = this.fieldManager.getField(StringUtils.defaultString(duration.getEndDateFieldKey()));
                DateProvider endDateProvider = this.getFirstDateProviderForField(endDateField);
                durationToDateProviders.put(duration, new DurationDateProviders(startDateField, startDateProvider, endDateField, endDateProvider));
            }
        }
        return durationToDateProviders;
    }

    private Map<Field, DateProvider> getFieldToDateProviderMap(Collection<String> dateFieldNames) {
        HashMap<Field, DateProvider> fieldToDateProviders = new HashMap<Field, DateProvider>();
        if (null != dateFieldNames) {
            Collection validFields = Collections2.filter((Collection)Collections2.transform(dateFieldNames, (Function)new Function<String, Field>(){

                public Field apply(String fieldName) {
                    return DefaultEntityAsEventService.this.fieldManager.getField(StringUtils.defaultString(fieldName));
                }
            }), (Predicate)Predicates.notNull());
            for (Field validField : validFields) {
                fieldToDateProviders.put(validField, this.getFirstDateProviderForField(validField));
            }
        }
        return fieldToDateProviders;
    }

    private DateProvider getFirstDateProviderForField(Field dateField) {
        Collection<DateProvider> dateProvidersForField;
        if (null != dateField && null != (dateProvidersForField = this.getDateProvider(dateField)) && !dateProvidersForField.isEmpty()) {
            return dateProvidersForField.iterator().next();
        }
        return null;
    }

    private Collection<Version> getVersionsFromQuery(Query query, ApplicationUser user) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (Project project : this.queryUtil.getBrowseableProjectsFromQuery(user, query)) {
            versions.addAll(Collections2.filter((Collection)project.getVersions(), (Predicate)Predicates.and((Predicate)Predicates.notNull(), (Predicate)new Predicate<Version>(){

                public boolean apply(Version version) {
                    return null != version.getReleaseDate();
                }
            })));
        }
        return versions;
    }

    Collection<DateProvider> getDateProvider(final Field field) {
        ArrayList<DateProvider> dateProviders = new ArrayList<DateProvider>();
        dateProviders.addAll(Collections2.filter(this.builtInProviders, (Predicate)new Predicate<DateProvider>(){

            public boolean apply(DateProvider builtInDateProvider) {
                return builtInDateProvider.handles(field);
            }
        }));
        if (field instanceof CustomField) {
            ArrayList<DateProvider> customFieldDateOverrideProviders = new ArrayList<DateProvider>();
            List dictionaryModuleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(DateProviderModuleDescriptor.class);
            if (null != dictionaryModuleDescriptors) {
                for (DateProviderModuleDescriptor dateProviderModuleDescriptor : dictionaryModuleDescriptors) {
                    DateProvider dateProvider = dateProviderModuleDescriptor.getModule();
                    if (!dateProvider.handles(field)) continue;
                    customFieldDateOverrideProviders.add(dateProvider);
                }
            }
            if (customFieldDateOverrideProviders.isEmpty() && this.customFieldDateProvider.handles(field)) {
                dateProviders.add(this.customFieldDateProvider);
            } else {
                dateProviders.addAll(customFieldDateOverrideProviders);
            }
        }
        return dateProviders;
    }

    private static class DurationDateProviders {
        private final Field startDateField;
        private final DateProvider startDateProvider;
        private final Field endDateField;
        private final DateProvider endDateProvider;

        private DurationDateProviders(Field startDateField, DateProvider startDateProvider, Field endDateField, DateProvider endDateProvider) {
            this.startDateField = startDateField;
            this.startDateProvider = startDateProvider;
            this.endDateField = endDateField;
            this.endDateProvider = endDateProvider;
        }

        public Field getStartDateField() {
            return this.startDateField;
        }

        public DateProvider getStartDateProvider() {
            return this.startDateProvider;
        }

        public Field getEndDateField() {
            return this.endDateField;
        }

        public DateProvider getEndDateProvider() {
            return this.endDateProvider;
        }
    }
}

