/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.extra.icalfeed;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.extra.icalfeed.service.EntityAsEventService;
import com.atlassian.jira.extra.icalfeed.util.QueryUtil;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.search.SharedEntitySearchParametersBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.extensions.property.WrCalDesc;
import net.fortuna.ical4j.extensions.property.WrCalName;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.parameter.XParameter;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="ical")
@AnonymousAllowed
public class IcalendarResource {
    private static final Logger LOG = LoggerFactory.getLogger(IcalendarResource.class);
    private static final Collection<String> BUILT_IN_SYSTEM_FIELD_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("created", "updated", "duedate", "resolution")));
    private String CALENDAR_PRODUCT_ID = "-//Atlassian JIRA//iCalendar Plugin 1.0//EN";
    private static final String X_PROP_ISSUE_DATE_FIELD_NAME = "X-JIRA-ISSUE-DATE-FIELD";
    private static final String X_PARAM_ISSUE_DATE_FIELD_KEY = "X-JIRA-ISSUE-DATE-FIELD-KEY";
    private static final String X_PROP_ISSUE_END_DATE_FIELD_NAME = "X-JIRA-ISSUE-END-DATE-FIELD";
    private static final String X_PARAM_ISSUE_END_DATE_FIELD_KEY = "X-JIRA-ISSUE-END-DATE-FIELD-KEY";
    private static final String X_PARAM_UID_STATIC = "X-JIRA-UID-STATIC";
    private static final String X_PROJECT = "X-JIRA-PROJECT";
    private static final String X_PROJECT_KEY = "X-JIRA-PROJECT-KEY";
    private static final String X_PROJECT_ID = "X-JIRA-PROJECT-ID";
    private static final String X_ISSUE_KEY = "X-JIRA-ISSUE-KEY";
    private static final String X_ISSUE_STATUS = "X-JIRA-STATUS";
    private static final String X_ISSUE_RESOLUTION = "X-JIRA-RESOLUTION";
    private static final String X_ASSIGNEE = "X-JIRA-ASSIGNEE";
    private static final String X_ASSIGNEE_ID = "X-JIRA-ASSIGNEE-ID";
    private static final String X_VERSION_ID = "X-JIRA-VERSION-ID";
    private static final String X_VERSION_RELEASED = "X-JIRA-VERSION-RELEASED";
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final EntityAsEventService entityAsEventService;
    private final SearchService searchService;
    private final TimeZoneRegistry timeZoneRegistry;
    private final FieldManager fieldManager;
    private final CustomFieldManager customFieldManager;
    private final QueryUtil queryUtil;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final SearchRequestService searchRequestService;
    private final AutoCompleteJsonGenerator autoCompleteJsonGenerator;

    public IcalendarResource(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, EntityAsEventService entityAsEventService, SearchService searchService, FieldManager fieldManager, CustomFieldManager customFieldManager, QueryUtil queryUtil, ProjectManager projectManager, PermissionManager permissionManager, SearchRequestService searchRequestService) {
        this.applicationProperties = applicationProperties;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.entityAsEventService = entityAsEventService;
        this.searchService = searchService;
        this.fieldManager = fieldManager;
        this.customFieldManager = customFieldManager;
        this.queryUtil = queryUtil;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.searchRequestService = searchRequestService;
        this.autoCompleteJsonGenerator = (AutoCompleteJsonGenerator)ComponentManager.getComponentInstanceOfType(AutoCompleteJsonGenerator.class);
        this.timeZoneRegistry = TimeZoneRegistryFactory.getInstance().createRegistry();
    }

    @Path(value="project/{projectKey}/events.ics")
    @GET
    @Produces(value={"text/calendar"})
    public Response getIcalendarByProject(@PathParam(value="projectKey") String projectKey, @QueryParam(value="dateFieldName") List<String> dateFieldNames, @QueryParam(value="duration") List<String> durations, @QueryParam(value="includeFixVersions") boolean includeFixVersions, @DefaultValue(value="0") @QueryParam(value="start") long start, @DefaultValue(value="0") @QueryParam(value="end") long end, @DefaultValue(value="0") @QueryParam(value="maxIssue") int maxIssue) {
        try {
            if (StringUtils.isBlank(projectKey)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            return this.createIcalendarResponse(this.search(JqlQueryBuilder.newBuilder().where().project(new String[]{projectKey}).buildQuery(), dateFieldNames, durations, includeFixVersions, this.jiraAuthenticationContext.getLoggedInUser(), start, end, maxIssue));
        }
        catch (Exception generalError) {
            LOG.error("Unable to export issues to iCalendar", (Throwable)generalError);
            return Response.serverError().build();
        }
    }

    @Path(value="search/jql/events.ics")
    @GET
    @Produces(value={"text/calendar"})
    public Response getIcalendarByJql(@QueryParam(value="jql") String jql, @QueryParam(value="dateFieldName") List<String> dateFieldNames, @QueryParam(value="duration") List<String> durations, @QueryParam(value="includeFixVersions") boolean includeFixVersions, @DefaultValue(value="0") @QueryParam(value="start") long start, @DefaultValue(value="0") @QueryParam(value="end") long end, @DefaultValue(value="0") @QueryParam(value="maxIssue") int maxIssue) {
        try {
            if (StringUtils.isBlank(jql)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
            SearchService.ParseResult jqlParseResult = this.searchService.parseQuery(loggedInUser, StringUtils.defaultString(jql));
            if (!jqlParseResult.isValid()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Query query = jqlParseResult.getQuery();
            MessageSet messageSet = this.searchService.validateQuery(loggedInUser, query);
            if (messageSet.hasAnyErrors()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            return this.createIcalendarResponse(this.search(query, dateFieldNames, durations, includeFixVersions, loggedInUser, start, end, maxIssue));
        }
        catch (Exception generalError) {
            LOG.error("Unable to export issues to iCalendar", (Throwable)generalError);
            return Response.serverError().build();
        }
    }

    @Path(value="search/filter/events.ics")
    @GET
    @Produces(value={"text/calendar"})
    public Response getIcalendarByJql(@QueryParam(value="searchFilterId") long searchFilterId, @QueryParam(value="dateFieldName") List<String> dateFieldNames, @QueryParam(value="duration") List<String> durations, @QueryParam(value="includeFixVersions") boolean includeFixVersions, @DefaultValue(value="0") @QueryParam(value="start") long start, @DefaultValue(value="0") @QueryParam(value="end") long end, @DefaultValue(value="0") @QueryParam(value="maxIssue") int maxIssue) {
        try {
            ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
            SearchRequest searchRequest = this.searchRequestService.getFilter((JiraServiceContext)new JiraServiceContextImpl(loggedInUser), Long.valueOf(searchFilterId));
            if (null == searchRequest) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            return this.createIcalendarResponse(this.search(searchRequest.getQuery(), dateFieldNames, durations, includeFixVersions, loggedInUser, start, end, maxIssue));
        }
        catch (Exception generalError) {
            LOG.error("Unable to export issues to iCalendar", (Throwable)generalError);
            return Response.serverError().build();
        }
    }

    private Response createIcalendarResponse(Calendar calendar) throws IOException, ValidationException {
        StringWriter iCalendarWriter = new StringWriter();
        new CalendarOutputter(false).output(calendar, iCalendarWriter);
        return Response.ok((Object)((Object)iCalendarWriter).toString()).build();
    }

    private Calendar search(Query query, Collection<String> dateFieldNames, Collection<String> durations, boolean includeFixVersions, ApplicationUser user, long start, long end, int maxIssue) throws SearchException, ParseException, MalformedURLException, URISyntaxException {
        return this.toIcalendar(this.entityAsEventService.search(query, dateFieldNames, Collections2.filter((Collection)Collections2.transform(null == durations ? Collections.emptySet() : durations, (Function)new DurationQueryParamsToDurationsTransformFunction()), (Predicate)Predicates.notNull()), includeFixVersions, user, start, end, maxIssue));
    }

    private Calendar toIcalendar(EntityAsEventService.Result result) throws ParseException, MalformedURLException, URISyntaxException {
        ComponentList iCalendarComponents = new ComponentList();
        TimeZone timeZone = this.timeZoneRegistry.getTimeZone(TimeZone.getDefault().getID());
        VTimeZone vTimeZone = timeZone.getVTimeZone();
        iCalendarComponents.add(vTimeZone);
        PropertyList iCalendarProps = new PropertyList();
        iCalendarProps.add(new ProdId(this.CALENDAR_PRODUCT_ID));
        iCalendarProps.add(Version.VERSION_2_0);
        iCalendarProps.add(CalScale.GREGORIAN);
        iCalendarProps.add(new WrCalName(new ParameterList(), WrCalName.FACTORY, StringUtils.defaultString(this.applicationProperties.getDefaultBackedString("jira.title"))));
        iCalendarProps.add(new WrCalDesc(new ParameterList(), WrCalDesc.FACTORY, StringUtils.defaultString(this.applicationProperties.getDefaultBackedString("jira.title"))));
        iCalendarProps.add(new XProperty("X-WR-TIMEZONE", new ParameterList(), vTimeZone.getTimeZoneId().getValue()));
        DateTimeFormatter allDayDateValueFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd");
        StringBuilder urlBuilder = new StringBuilder();
        for (EntityAsEventService.IssueDateResult issueDateResult : result.issues) {
            iCalendarComponents.add(this.toVEvent(allDayDateValueFormatter, urlBuilder, issueDateResult, timeZone));
        }
        for (com.atlassian.jira.project.version.Version affectedVersion : result.affectedVersions) {
            iCalendarComponents.add(this.toVEvent(allDayDateValueFormatter, urlBuilder, affectedVersion));
        }
        for (com.atlassian.jira.project.version.Version fixVersion : result.fixedVersions) {
            iCalendarComponents.add(this.toVEvent(allDayDateValueFormatter, urlBuilder, fixVersion));
        }
        return new Calendar(iCalendarProps, iCalendarComponents);
    }

    private VEvent toVEvent(DateTimeFormatter allDayDateValueFormatter, StringBuilder urlBuilder, com.atlassian.jira.project.version.Version version) throws ParseException, URISyntaxException, MalformedURLException {
        PropertyList vEventProps = new PropertyList();
        urlBuilder.setLength(0);
        urlBuilder.append(String.valueOf(version.getId())).append('@').append(this.getHostFromBaseUrl());
        vEventProps.add(new Uid(new ParameterList(){
            {
                this.add(new XParameter(IcalendarResource.X_PARAM_UID_STATIC, Boolean.TRUE.toString()));
            }
        }, urlBuilder.toString()));
        vEventProps.add(new Summary(version.getName()));
        DateTime releaseDate = new DateTime(version.getReleaseDate().getTime());
        vEventProps.add(new DtStart(new Date(allDayDateValueFormatter.print((ReadableInstant)releaseDate))));
        vEventProps.add(new DtEnd(new Date(allDayDateValueFormatter.print((ReadableInstant)releaseDate.plusDays(1)))));
        if (StringUtils.isNotBlank(version.getDescription())) {
            vEventProps.add(new Description(version.getDescription()));
        }
        vEventProps.add(new XProperty(X_VERSION_ID, String.valueOf(version.getId())));
        vEventProps.add(new XProperty(X_VERSION_RELEASED, String.valueOf(version.isReleased())));
        final Project versionProject = version.getProjectObject();
        vEventProps.add(new XProperty(X_PROJECT, new ParameterList(){
            {
                this.add(new XParameter(IcalendarResource.X_PROJECT_KEY, versionProject.getKey()));
                this.add(new XParameter(IcalendarResource.X_PROJECT_ID, String.valueOf(versionProject.getId())));
            }
        }, versionProject.getName()));
        return new VEvent(vEventProps);
    }

    private String getHostFromBaseUrl() throws MalformedURLException {
        return new URL(this.getBaseUrl()).getHost();
    }

    private String getBaseUrl() {
        return this.applicationProperties.getDefaultBackedString("jira.baseurl");
    }

    private VEvent toVEvent(DateTimeFormatter allDayDateValueFormatter, StringBuilder urlBuilder, final EntityAsEventService.IssueDateResult issueDateResult, TimeZone systemTimeZoneAsCalendarTimeZone) throws ParseException, URISyntaxException, MalformedURLException {
        PropertyList vEventProps = new PropertyList();
        urlBuilder.setLength(0);
        urlBuilder.append(issueDateResult.issueKey);
        vEventProps.add(this.getDateFieldVeventProperty(issueDateResult));
        if (issueDateResult instanceof EntityAsEventService.SingleDateIssueResult) {
            urlBuilder.append('-').append(((EntityAsEventService.SingleDateIssueResult)issueDateResult).dateFieldKey);
        } else if (issueDateResult instanceof EntityAsEventService.DurationIssueResult) {
            EntityAsEventService.DurationIssueResult durationIssueResult = (EntityAsEventService.DurationIssueResult)issueDateResult;
            urlBuilder.append('-').append(durationIssueResult.startDateFieldKey).append('-').append(durationIssueResult.endDateFieldKey);
            vEventProps.add(this.getEndDateFieldVeventProperty(durationIssueResult));
        }
        urlBuilder.append('@').append(this.getHostFromBaseUrl());
        vEventProps.add(new Uid(new ParameterList(){
            {
                this.add(new XParameter(IcalendarResource.X_PARAM_UID_STATIC, Boolean.TRUE.toString()));
            }
        }, urlBuilder.toString()));
        vEventProps.add(new Summary(issueDateResult.issueSummary));
        if (issueDateResult.allDay) {
            vEventProps.add(new DtStart(new Date(allDayDateValueFormatter.print((ReadableInstant)issueDateResult.start))));
            vEventProps.add(new DtEnd(new Date(allDayDateValueFormatter.print((ReadableInstant)issueDateResult.end))));
        } else {
            DtStart dtStart = new DtStart(new net.fortuna.ical4j.model.DateTime(issueDateResult.start.toDate()));
            dtStart.setTimeZone(systemTimeZoneAsCalendarTimeZone);
            vEventProps.add(dtStart);
            DtEnd dtEnd = new DtEnd(new net.fortuna.ical4j.model.DateTime(issueDateResult.end.toDate()));
            dtEnd.setTimeZone(systemTimeZoneAsCalendarTimeZone);
            vEventProps.add(dtEnd);
        }
        if (StringUtils.isNotBlank(issueDateResult.issueDescription)) {
            vEventProps.add(new Description(issueDateResult.issueDescription));
        }
        if (null != issueDateResult.assignee) {
            vEventProps.add(new XProperty(X_ASSIGNEE, new ParameterList(){
                {
                    this.add(new XParameter(IcalendarResource.X_ASSIGNEE_ID, issueDateResult.assignee.getName()));
                }
            }, issueDateResult.assignee.getDisplayName()));
        }
        vEventProps.add(new DtStamp(new net.fortuna.ical4j.model.DateTime(issueDateResult.issueCreated.toDate())));
        vEventProps.add(new Created(new net.fortuna.ical4j.model.DateTime(issueDateResult.issueCreated.toDate())));
        vEventProps.add(new LastModified(new net.fortuna.ical4j.model.DateTime(issueDateResult.issueUpdated.toDate())));
        vEventProps.add(new XProperty(X_ISSUE_KEY, issueDateResult.issueKey));
        vEventProps.add(new XProperty(X_ISSUE_STATUS, issueDateResult.status));
        vEventProps.add(new XProperty(X_ISSUE_RESOLUTION, issueDateResult.resolution));
        return new VEvent(vEventProps);
    }

    private Property getEndDateFieldVeventProperty(EntityAsEventService.DurationIssueResult durationIssueResult) {
        ParameterList propertyParams = new ParameterList();
        propertyParams.add(new XParameter(X_PARAM_ISSUE_END_DATE_FIELD_KEY, durationIssueResult.endDateFieldKey));
        return new XProperty(X_PROP_ISSUE_END_DATE_FIELD_NAME, propertyParams, durationIssueResult.endDateFieldName);
    }

    private Property getDateFieldVeventProperty(EntityAsEventService.IssueDateResult issueDateResult) {
        ParameterList propertyParams = new ParameterList();
        if (issueDateResult instanceof EntityAsEventService.SingleDateIssueResult) {
            EntityAsEventService.SingleDateIssueResult singleDateIssueResult = (EntityAsEventService.SingleDateIssueResult)issueDateResult;
            propertyParams.add(new XParameter(X_PARAM_ISSUE_DATE_FIELD_KEY, singleDateIssueResult.dateFieldKey));
            return new XProperty(X_PROP_ISSUE_DATE_FIELD_NAME, propertyParams, singleDateIssueResult.dateFieldName);
        }
        if (issueDateResult instanceof EntityAsEventService.DurationIssueResult) {
            EntityAsEventService.DurationIssueResult durationIssueResult = (EntityAsEventService.DurationIssueResult)issueDateResult;
            propertyParams.add(new XParameter(X_PARAM_ISSUE_DATE_FIELD_KEY, durationIssueResult.startDateFieldKey));
            return new XProperty(X_PROP_ISSUE_DATE_FIELD_NAME, propertyParams, durationIssueResult.startDateFieldName);
        }
        return null;
    }

    @Path(value="config/fields")
    @GET
    @Produces(value={"application/json"})
    public Response getDateFields(@QueryParam(value="jql") String jql, @QueryParam(value="searchRequestId") long searchRequestId) {
        Set<Project> browseableProjectsInQuery;
        Query searchQuery;
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        if (0L == searchRequestId) {
            if (StringUtils.isBlank(jql)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            SearchService.ParseResult jqlParseResult = this.searchService.parseQuery(loggedInUser, StringUtils.defaultString(jql));
            if (!jqlParseResult.isValid()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            searchQuery = jqlParseResult.getQuery();
        } else {
            SearchRequest searchRequest = this.searchRequestService.getFilter((JiraServiceContext)new JiraServiceContextImpl(loggedInUser), Long.valueOf(searchRequestId));
            if (null == searchRequest) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            searchQuery = searchRequest.getQuery();
        }
        HashSet<String> fieldKeys = new HashSet<String>(BUILT_IN_SYSTEM_FIELD_KEYS);
        List globalCustomFields = this.customFieldManager.getGlobalCustomFieldObjects();
        if (null != globalCustomFields) {
            for (CustomField globalCustomField : Collections2.filter((Collection)globalCustomFields, (Predicate)new IsDateCustomFieldPredicate())) {
                fieldKeys.add(globalCustomField.getId());
            }
        }
        if ((browseableProjectsInQuery = this.queryUtil.getBrowseableProjectsFromQuery(this.jiraAuthenticationContext.getLoggedInUser(), searchQuery)).size() == 1) {
            for (Project browseableProject : browseableProjectsInQuery) {
                List customFieldsInProject = this.customFieldManager.getCustomFieldObjects(browseableProject.getId(), "-4");
                if (null == customFieldsInProject) continue;
                for (CustomField customField : Collections2.filter((Collection)customFieldsInProject, (Predicate)new IsDateCustomFieldPredicate())) {
                    fieldKeys.add(customField.getId());
                }
            }
        }
        return Response.ok(new ArrayList(Lists.transform(new ArrayList<String>(fieldKeys), (Function)new Function<String, DateField>(){

            public DateField apply(String fieldKey) {
                com.atlassian.jira.issue.fields.Field aField = IcalendarResource.this.fieldManager.getField(fieldKey);
                DateField aDateField = new DateField();
                aDateField.name = aField.getName();
                aDateField.key = aField.getId();
                return aDateField;
            }
        }))).build();
    }

    @Path(value="config/query/options")
    @GET
    @Produces(value={"application/json"})
    public Response getQueryOptions() throws JSONException {
        final ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        ArrayList simpleProjects = Lists.newArrayList((Iterable)Collections2.transform((Collection)Collections2.filter((Collection)this.projectManager.getProjectObjects(), (Predicate)Predicates.and((Predicate)Predicates.notNull(), (Predicate)new Predicate<Project>(){

            public boolean apply(Project project) {
                return IcalendarResource.this.permissionManager.hasPermission(10, project, loggedInUser);
            }
        })), (Function)new Function<Project, SimpleProject>(){

            public SimpleProject apply(Project project) {
                SimpleProject simpleProject = new SimpleProject();
                simpleProject.key = project.getKey();
                simpleProject.name = project.getName();
                return simpleProject;
            }
        }));
        Collections.sort(simpleProjects);
        ArrayList searchFilters = Lists.newArrayList((Iterable)Collections2.transform(this.getSearchFiltersForUser(loggedInUser), (Function)new Function<SearchRequest, SearchFilter>(){

            public SearchFilter apply(SearchRequest searchRequest) {
                SearchFilter searchFilter = new SearchFilter();
                searchFilter.id = searchRequest.getId();
                searchFilter.name = searchRequest.getName();
                searchFilter.description = searchRequest.getDescription();
                return searchFilter;
            }
        }));
        Collections.sort(searchFilters);
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.projects = simpleProjects;
        queryOptions.searchFilters = searchFilters;
        Locale userLocale = this.jiraAuthenticationContext.getLocale();
        queryOptions.visibleFieldNames = this.autoCompleteJsonGenerator.getVisibleFieldNamesJson(loggedInUser, userLocale);
        queryOptions.visibleFunctionNamesJson = this.autoCompleteJsonGenerator.getVisibleFunctionNamesJson(loggedInUser, userLocale);
        queryOptions.jqlReservedWordsJson = this.autoCompleteJsonGenerator.getJqlReservedWordsJson();
        return Response.ok((Object)queryOptions).build();
    }

    @Path(value="util/jql/validate")
    @POST
    @Produces(value={"application/json"})
    public Response validateJql(@FormParam(value="jql") String jql) {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        SearchService.ParseResult jqlParseResult = this.searchService.parseQuery(loggedInUser, StringUtils.defaultString(jql));
        JqlValidationErrors jqlValidationErrors = new JqlValidationErrors();
        if (jqlParseResult.isValid()) {
            return Response.ok((Object)jqlValidationErrors).build();
        }
        MessageSet validationMessageSet = jqlParseResult.getErrors();
        jqlValidationErrors.errorMessages = validationMessageSet.getErrorMessages();
        jqlValidationErrors.warningMessages = validationMessageSet.getWarningMessages();
        return Response.ok((Object)jqlValidationErrors).build();
    }

    private Collection<SearchRequest> getSearchFiltersForUser(ApplicationUser loggedInUser) {
        return this.searchRequestService.search((JiraServiceContext)new JiraServiceContextImpl(loggedInUser), this.prepareSharedEntitySearchParametersBuilder(new SharedEntitySearchParametersBuilder()).toSearchParameters(), 0, Integer.MAX_VALUE).getResults();
    }

    private SharedEntitySearchParametersBuilder prepareSharedEntitySearchParametersBuilder(SharedEntitySearchParametersBuilder sharedEntitySearchParametersBuilder) {
        try {
            Class<?> sharedEntitySearchContextClazz = this.getClass().getClassLoader().loadClass("com.atlassian.jira.sharing.search.SharedEntitySearchContext");
            Field useField = sharedEntitySearchContextClazz.getField("USE");
            if (Modifier.isStatic(useField.getModifiers())) {
                Method setEntitySearchContextMethod = sharedEntitySearchParametersBuilder.getClass().getMethod("setEntitySearchContext", sharedEntitySearchContextClazz);
                setEntitySearchContextMethod.invoke((Object)sharedEntitySearchParametersBuilder, useField.get(null));
            }
        }
        catch (ClassNotFoundException sharedEntitySearchContextDoesNotExist) {
            LOG.debug("Unable to find class SharedEntitySearchContext", (Throwable)sharedEntitySearchContextDoesNotExist);
        }
        catch (NoSuchFieldException useFieldNotFound) {
            LOG.debug("Unable to find static field \"USE\" in SharedEntitySearchContext", (Throwable)useFieldNotFound);
        }
        catch (NoSuchMethodException setEntitySearchContextMethodNotFound) {
            LOG.debug("Unable to find SharedEntitySearchParametersBuilder.setEntitySearchContext()", (Throwable)setEntitySearchContextMethodNotFound);
        }
        catch (IllegalAccessException unableToSetSearchContext) {
            LOG.debug("Invalid access to SharedEntitySearchParametersBuilder.setEntitySearchContext()", (Throwable)unableToSetSearchContext);
        }
        catch (InvocationTargetException setSearchContextError) {
            LOG.debug("Error invoking SharedEntitySearchParametersBuilder.setEntitySearchContext()", (Throwable)setSearchContextError);
        }
        return sharedEntitySearchParametersBuilder;
    }

    @Path(value="util/jql/count")
    @POST
    @Produces(value={"application/json"})
    public Response getIssueCountFromJql(@FormParam(value="jql") String jql, @FormParam(value="dateFieldName") List<String> dateFieldNames, @FormParam(value="duration") List<String> durations, @FormParam(value="includeFixVersions") boolean includeFixVersions) {
        try {
            if (StringUtils.isBlank(jql)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
            SearchService.ParseResult jqlParseResult = this.searchService.parseQuery(loggedInUser, StringUtils.defaultString(jql));
            if (jqlParseResult.isValid()) {
                if (includeFixVersions) {
                    dateFieldNames = new ArrayList<String>(dateFieldNames);
                    dateFieldNames.add("versiondue");
                }
                SearchResultsCount searchResultsCount = new SearchResultsCount();
                searchResultsCount.total = this.searchService.searchCount(loggedInUser, this.queryUtil.getQueryWithDateFieldsOptimised(jqlParseResult.getQuery(), dateFieldNames, Collections2.transform(null == durations ? Collections.emptySet() : durations, (Function)new DurationQueryParamsToDurationsTransformFunction()), 0L, 0L));
                return Response.ok((Object)searchResultsCount).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception generalError) {
            LOG.error(String.format("Unable to get the count of issues for JQL: %s[%s; %s; %s]", jql, dateFieldNames, durations, includeFixVersions), (Throwable)generalError);
            return Response.serverError().build();
        }
    }

    private static class DurationQueryParamsToDurationsTransformFunction
    implements Function<String, EntityAsEventService.Duration> {
        private DurationQueryParamsToDurationsTransformFunction() {
        }

        public EntityAsEventService.Duration apply(String durationPairStr) {
            String[] startEndPair = StringUtils.split(durationPairStr, "/", 2);
            if (startEndPair.length == 2) {
                return new EntityAsEventService.Duration(startEndPair[0], startEndPair[1]);
            }
            return null;
        }
    }

    @XmlRootElement
    public static class SearchResultsCount {
        @XmlElement
        public long total;

        public SearchResultsCount(long total) {
            this.total = total;
        }

        public SearchResultsCount() {
            this(0L);
        }
    }

    @XmlRootElement
    public static class SearchFilter
    implements Comparable<SearchFilter> {
        @XmlElement
        public long id;
        @XmlElement
        public String name;
        @XmlElement
        public String description;

        @Override
        public int compareTo(SearchFilter searchFilter) {
            int result = StringUtils.defaultString(this.name).compareTo(StringUtils.defaultString(searchFilter.name));
            return 0 == result ? (int)(this.id - searchFilter.id) : result;
        }
    }

    @XmlRootElement
    public static class SimpleProject
    implements Comparable<SimpleProject> {
        @XmlElement
        public String key;
        @XmlElement
        public String name;

        @Override
        public int compareTo(SimpleProject simpleProject) {
            int result = StringUtils.defaultString(this.name).compareTo(StringUtils.defaultString(simpleProject.name));
            return 0 == result ? this.key.compareTo(simpleProject.key) : result;
        }
    }

    @XmlRootElement
    public static class QueryOptions {
        @XmlElement
        public List<SimpleProject> projects;
        @XmlElement
        public List<SearchFilter> searchFilters;
        @XmlElement
        public String visibleFieldNames;
        @XmlElement
        public String visibleFunctionNamesJson;
        @XmlElement
        public String jqlReservedWordsJson;
        @XmlElement
        public boolean dateRangeSupported = true;
    }

    @XmlRootElement
    public static class JqlValidationErrors {
        @XmlElement
        public Set<String> errorMessages;
        @XmlElement
        public Set<String> warningMessages;
    }

    private static class IsDateCustomFieldPredicate
    implements Predicate<CustomField> {
        private IsDateCustomFieldPredicate() {
        }

        public boolean apply(CustomField field) {
            return null != field && (field.getCustomFieldType() instanceof DateTimeCFType || field.getCustomFieldType() instanceof DateCFType);
        }
    }

    @XmlRootElement
    public static class DateField {
        @XmlElement
        public String key;
        @XmlElement
        public String name;
    }
}

