define("jira-help-tips/util/analytics", function() {
    "use strict";

    // to un-fuck graphite event names
    function cleanAnalyticsName(name) {
        name = "" + (name || "");
        return name.replace(/\./g, "-");
    }

    function queue() {
        return AJS && AJS.EventQueue;
    }

    function analytics(eventId, model) {
        if (queue() && model && model.attributes.id) {
            var event = {};
            var cleanId = cleanAnalyticsName(model.attributes.id);
            var eventPrefix = "";

            if (model.attributes.eventPrefix) {
                eventPrefix = model.attributes.eventPrefix;
                // Ensure a dot at the end of the event prefix
                if (eventPrefix.charAt(eventPrefix.length - 1) !== ".") {
                    eventPrefix += ".";
                }
            }

            event.name = eventPrefix + "helptips." + cleanId + "." + eventId;
            event.properties = {};
            queue().push(event);
        }
    }

    return {
        clean: cleanAnalyticsName,
        send: analytics
    };
});
