AJS.test.require(["com.atlassian.plugins.helptips.jira-help-tips:help-tip"],function(){var c=require("jquery");var b=require("jira-help-tips/feature/help-tip-manager");var a=require("jira-help-tips/feature/help-tip");module("jira-help-tips/feature/help-tip");test("can create new tips",function(){var d=new a();equal(typeof d,"object","should be an object")});test("get a unique client id (cid)",function(){var e=[];for(var d=0;d<20;d++){e.push((new a()).cid)}equal(c.unique(e).length,e.length,"should be as many unique ids as tips created")});test("can be programmatically dismissed",function(){var d=new a({body:"whee"});ok(!d.isDismissed(),"has not been dismissed yet");d.dismiss();ok(d.isDismissed(),"should be dismissed")});test("can bind dismissal of tip to other elements",function(){var e=new a({body:"whee"});var d=c("<a>click me to dismiss</a>");d.click(function(){e.dismiss()});d.trigger("click");ok(e.isDismissed(),"should be dismissed after clicking the anchor link")});test("tips with the same id have a linked dismissed value",function(){this.sandbox.stub(b,"sync");var d=new a({id:"testtip",body:"firsttip"});var e=new a({id:"testtip",body:"secondtip"});d.dismiss();ok(e.isDismissed(),"tip2 is considered dismissed because tip1 was.")});test("tips with no id are considered different",function(){var d=new a({body:"firsttip"});var e=new a({body:"secondtip"});d.dismiss();ok(!e.isDismissed(),"tip2 is different to tip1 as neither have the same id.")});module("anchored tip",{setup:function(){c.fx.off=true;this.context=AJS.test.mockableModuleContext();this.sandbox=sinon.sandbox.create({useFakeTimers:true,useFakeServer:true});this.clock=this.sandbox.clock;this.fakeSync=this.sandbox.stub(b,"sync");this.fakeShow=this.sandbox.stub(b,"show",function(d){d()});this.container=c("<div>").attr("id","content").appendTo("#qunit-fixture");this.box=c("<div></div>").appendTo("#qunit-fixture");this.anchor=c("<a>test</a>").appendTo(this.box);this.tip=new a({body:"test "+new Date(),anchor:this.anchor})},teardown:function(){this.container.remove();this.box.remove();this.tip=null;this.sandbox.restore();c.fx.off=false},setupSequences:function(){b.loaded=c.Deferred();b.showSequences();b.loaded.resolve()},teardownSequences:function(){b.dismissedTipIds=[];b.loaded=c.Deferred();b.clearSequences();b.loaded.resolve()}});test("can be anchored to an element",function(){this.tip.show();this.clock.tick(0);ok(this.tip.isVisible(),"tip should be visible")});test("cannot be dismissed by clicking outside the tip",function(){this.tip.show();this.clock.tick(0);c(document.body).trigger("click");ok(this.tip.isVisible(),"tip should still be visible");ok(!this.tip.isDismissed(),"not dismissed yet")});test("tip disappears when dismissed",function(){this.tip.show();this.clock.tick(0);this.tip.dismiss();this.clock.tick(0);ok(!this.tip.isVisible(),"should no longer be visible")});test("can click a close button to dismiss",function(){this.tip.show();this.clock.tick(0);var d=c(".helptip-close",this.tip.view.$el);ok(d.length,"there should be a button on the anchored tip to dismiss it");ok(!this.tip.isDismissed(),"is not yet dismissed");d.trigger("click");this.clock.tick(0);ok(this.tip.isDismissed(),"should be dismissed after clicking the close button")});test("once dismissed, cannot be re-opened",function(){this.tip.show();this.clock.tick(0);this.tip.dismiss();this.clock.tick(0);this.tip.show();ok(!this.tip.isVisible(),"should not be visible once closed")});test("tip can be hidden",function(){this.tip.show();this.clock.tick(0);this.tip.hide();this.clock.tick(0);ok(!this.tip.isVisible(),"should be hidden")});test("can show again after hide",function(){this.tip.show();this.clock.tick(0);this.tip.hide();this.clock.tick(0);this.tip.show();this.clock.tick(0);ok(this.tip.isVisible(),"should be visible after hiding")});test("refresh on a tip with hidden anchor hides the tip",function(){this.tip.show();this.clock.tick(0);ok(this.tip.isVisible(),"should be visible");this.anchor.hide();this.clock.tick(0);ok(this.tip.isVisible(),"should be visible after anchor is hidden and refresh not called");this.tip.refresh();this.clock.tick(0);ok(!this.tip.isVisible(),"should not be visible after anchor is hidden and refresh called")});test("refresh on a tip that isnt shown yet shows the tip",function(){ok(!this.tip.isVisible(),"should not be visible");this.tip.refresh();this.clock.tick(0);ok(this.tip.isVisible(),"should be visible after refresh")});test("test inline dialog options is passed from helptip constructors",function(){expect(5);var g=this.sandbox.stub().returns({hide:c.noop});this.context.mock("aui/inline-dialog",g);var e=this.context.require("jira-help-tips/feature/help-tip");var d={offsetX:999,offsetY:-999,arrowOffsetX:9001,container:"fixture",initCallback:this.sandbox.spy()};new e({body:"test "+new Date(),anchor:this.anchor,callbacks:{init:c.noop},inlineDialogOpts:d});var f=g.args[0][3];_.each(d,function(h,i){ok(f[i]===h,"options passed in from constructor should replace the default inline dialog options from helptip")})});test("test helptips to be shown in sequence for next button",function(){c("#qunit-fixture").append("<a class='anchorOne'></a><a class='anchorTwo'></a>");var e=new a({id:"seq1",body:"I am a test 1.",isSequence:true,anchor:".anchorOne"});var d=new a({id:"seq2",body:"I am a test 2.",isSequence:true,anchor:".anchorTwo"});this.setupSequences();var f=c(".helptip-next",e.view.$el);equal(c(".helptip-sequence-paging",e.view.$el).text(),"1/2","Helptips include paging when shown in sequence");equal(f.length,1,"Helptips include next button when shown in sequence");f.click();equal(c(".helptip-sequence-paging",d.view.$el).text(),"2/2","Helptips include paging when shown in sequence");equal(c(".helptip-close",d.view.$el).length,1,"Helptips include close button when it is the last one");equal(c(".helptip-next",d.view.$el).length,0,"Helptips does not include next button when it is the last one");this.teardownSequences()});test("test can move to the next help tip in sequence programatically",function(){c("#qunit-fixture").append("<a class='anchorOne'></a><a class='anchorTwo'></a>");var e=new a({id:"seq1",body:"I am a test 1.",isSequence:true,anchor:".anchorOne"});var d=new a({id:"seq2",body:"I am a test 2.",isSequence:true,anchor:".anchorTwo"});equal(c(".helptip-sequence-paging").length,0);this.setupSequences();equal(c(".helptip-sequence-paging").length,1);equal(c(".helptip-sequence-paging").last().text(),"1/2");e.showNextHelpTipInSequence();equal(c(".helptip-sequence-paging").length,2);equal(c(".helptip-sequence-paging").last().text(),"2/2");d.showNextHelpTipInSequence();equal(c(".helptip-sequence-paging").length,2);this.teardownSequences()});test("test never show paging info for non-sequence help tip",function(){c("#qunit-fixture").append("<a class='anchorOne'></a><a class='anchorTwo'></a><a class='anchorThree'></a>");var f=new a({id:"seq1",body:"I am a test 1.",isSequence:true,anchor:".anchorOne"});var e=new a({id:"seq2",body:"I am a test 2.",isSequence:true,anchor:".anchorTwo"});var d=new a({id:"non-seq",body:"I am a test 3.",isSequence:false,anchor:".anchorThree"});equal(c(".helptip-sequence-paging").length,0);this.setupSequences();d.show();equal(c(".helptip-sequence-paging").length,1);equal(c(".helptip-sequence-paging").last().text(),"1/2");f.showNextHelpTipInSequence();equal(c(".helptip-sequence-paging").length,2);equal(c(".helptip-sequence-paging").last().text(),"2/2");e.showNextHelpTipInSequence();equal(c(".helptip-sequence-paging").length,2);this.teardownSequences()});test("test close button will be enabled on last tip in sequence if last tip is filtered out as dismissed",function(){c("#qunit-fixture").append("<a class='anchorOne'></a><a class='anchorTwo'></a>");var e=new a({id:"seq1",body:"I am a test 1.",isSequence:true,showCloseButton:false,anchor:".anchorOne"});var d=new a({id:"seq2",body:"I am a test 2.",isSequence:true,showCloseButton:true,anchor:".anchorTwo"});b.dismissedTipIds=["seq2"];equal(c(".helptip-sequence-paging").length,0);this.setupSequences();equal(c(".helptip-sequence-paging").length,0);equal(c(".helptip-close",e.view.$el).length,1,"Helptips include close button when it is the last one");this.teardownSequences()});test("test helptips to be shown in sequence for close button",function(){c("#qunit-fixture").append("<a class='anchorOne'></a><a class='anchorTwo'></a>");var e=new a({id:"seq1",body:"I am a test 1.",isSequence:true,anchor:".anchorOne"});var d=new a({id:"seq2",body:"I am a test 2.",isSequence:true,anchor:".anchorTwo"});this.setupSequences();var f=c(".helptip-close",e.view.$el);f.click();equal(c(".helptip-body",d.view.$el).length,0,"Closing the first tip shouldn't open the second tip");this.teardownSequences()});test("test helptips can choose to not have a close button",function(){c("#qunit-fixture").append("<a class='anchorOne'></a>");var d=new a({id:"helptip",body:"I am a test.",showCloseButton:false,anchor:".anchorOne"});d.show();equal(c(".helptip-close",d.view.$el).length,0,"The helptip should not have a close button")});test("test HelptipManager for tips to be shown in sequence",function(){c("#qunit-fixture").append("<a class='anchor'></a>");var e=new a({id:"seq1",body:"I am a test 1.",isSequence:true,anchor:".anchor"});var d=new a({id:"seq2",body:"I am a test 2.",isSequence:true,anchor:".anchor"});equal(b.sequences.length,2,"Helptips to be shown in sequence is added to the list");this.setupSequences();equal(b.sequences.length,2,"Helptips to be shown in sequence is added to the list");equal(c(".helptip-sequence-paging",e.view.$el).text(),"1/2","Helptips include paging when shown in sequence");equal(c(".helptip-close",e.view.$el).length,1,"Helptips include close button when shown in sequence");equal(c(".helptip-next",e.view.$el).length,1,"Helptips include next button when shown in sequence");b.dismissedTipIds.push("seq2");this.setupSequences();equal(b.sequences.length,1,"Helptips that have already been dismissed will not show");equal(c(".helptip-sequence-paging",e.view.$el).length,0,"Helptips do not include paging when it is the only one");equal(c(".helptip-close",e.view.$el).length,1,"Helptips include close button when it is the only one");equal(c(".helptip-next",e.view.$el).length,0,"Helptips does not include next button when it is the only one");this.teardownSequences()});module("anchored tip with anchor selector",{setup:function(){c.fx.off=true;this.sandbox=sinon.sandbox.create({useFakeTimers:true,useFakeServer:true});this.clock=this.sandbox.clock;this.container=c("<div>").attr("id","content").appendTo("#qunit-fixture");this.box=c("<div></div>").appendTo("#qunit-fixture");this.anchorSelectorClass="anchor-selector-class";this.anchorSelector="."+this.anchorSelectorClass;this.anchor1=c("<a>test</a>").appendTo(this.box);this.anchor2=c("<a>test</a>").appendTo(this.box);this.anchor1.addClass(this.anchorSelectorClass);this.tip=new a({body:"test "+new Date(),anchor:this.anchorSelector})},teardown:function(){this.tip=null;this.sandbox.restore();c.fx.off=false}});test("visible when matching anchor is present after refresh",function(){this.tip.show();this.clock.tick(0);ok(this.tip.isVisible(),"visible because the anchor selector matches");this.tip.refresh();this.clock.tick(0);ok(this.tip.isVisible(),"visible because the anchor selector matches")});test("not visible when matching anchor is absent",function(){this.tip.show();this.clock.tick(0);ok(this.tip.isVisible(),"visible because the anchor selector matches");this.anchor1.removeClass(this.anchorSelectorClass);this.tip.refresh();this.clock.tick(0);ok(!this.tip.isVisible(),"not visible because there are no anchors matching the selector")});test("refresh on a change of anchor",function(){this.anchor1.addClass(this.anchorSelectorClass);this.tip.show();this.clock.tick(0);ok(this.tip.isVisible(),"visible because the anchor selector matches");this.anchor1.removeClass(this.anchorSelectorClass);this.anchor2.addClass(this.anchorSelectorClass);this.tip.refresh();this.clock.tick(0);ok(this.tip.isVisible(),"visible because the second anchor matches")});module("persistence",{setup:function(){var d=this.requests=[];this.xhr=sinon.useFakeXMLHttpRequest();this.xhr.onCreate=function(e){d.push(e)}},teardown:function(){this.xhr.restore()}});test("sends nothing to the server if no ID was set",function(){var d=new a({body:"I have no ID-ah!"});d.dismiss();equal(this.requests.length,0,"no request was made to the server.")});test("POSTs the dismissal of the tip to the server",function(){var d=new a({id:"testtip2",body:"I am a test."});d.dismiss();equal(this.requests.length,1,"A request was sent to the server");equal(this.requests[0].requestBody,JSON.stringify({id:"testtip2"}))})});