AJS.test.require(["com.atlassian.plugins.helptips.jira-help-tips:help-tip"], function() {
    "use strict";

    var Manager = require("jira-help-tips/feature/help-tip-manager");
    var HelpTip = require("jira-help-tips/feature/help-tip");

    function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
    }

    function guid() {
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
            s4() + '-' + s4() + s4() + s4();
    }

    module('analytics', {
        setup: function() {
            this.queue = AJS.EventQueue = []; // To mock the presence of analytics
            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(Manager, "sync");
            this.sandbox.stub(Manager, "show", function(showTip) { showTip(); });

            this.id = "help-tip-" + guid();
            this.tip = new HelpTip({
                id: this.id,
                body: "whee"
            });
        },
        teardown: function() {
            this.sandbox.restore();
        }
    });

    test('Shown event is fired', function() {
        this.tip.show();
        equal(this.queue.length, 1, "Event has been fired");
        equal(this.queue[0].name, "helptips." + this.id + ".shown", "Event has correct name");
    });

    test('Dismissed event is fired, with reason given', function() {
        this.tip.dismiss("thereason");
        equal(this.queue.length, 1, "Event has been fired");
        equal(this.queue[0].name, "helptips." + this.id + ".dismissed.thereason", "Event has correct name");
    });

    test('Dismissed event is fired, with no reason given', function() {
        this.tip.dismiss();
        equal(this.queue.length, 1, "Event has been fired");
        equal(this.queue[0].name, "helptips." + this.id + ".dismissed.programmatically", "Event has correct name");
    });

    test('Event prefix given', function() {
        this.tip = new HelpTip({
            id: this.id,
            body: "whee",
            eventPrefix: "foobar"
        });
        this.tip.show();
        equal(this.queue.length, 1, "Event has been fired");
        equal(this.queue[0].name, "foobar.helptips." + this.id + ".shown", "Event has correct name");
    });

    test('Tip with no ID fires no events', function() {
        this.tip = new HelpTip({
            body: "whee"
        });
        equal(this.queue.length, 0, "No events were fired");
    });

});
