/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.helptips;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;

public class HelpTipManager {
    private final UserPropertyManager userPropertyManager;
    private static final String KEY_NAMESPACE = "jira.user.suppressedTips.";

    public HelpTipManager(UserPropertyManager userPropertyManager) {
        this.userPropertyManager = userPropertyManager;
    }

    public void dismissTip(ApplicationUser user, String id) {
        String tipId = this.getTipId(id);
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        propertySet.setBoolean(tipId, true);
    }

    public void undismissTip(ApplicationUser user, String id) {
        String tipId = this.getTipId(id);
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        if (propertySet.exists(tipId)) {
            propertySet.remove(tipId);
        }
    }

    public Collection<String> getDismissedTips(ApplicationUser user) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        Collection results = propertySet.getKeys(KEY_NAMESPACE);
        return Collections2.transform((Collection)results, (Function)new Function<String, String>(){

            public String apply(String from) {
                return from.substring(HelpTipManager.KEY_NAMESPACE.length());
            }
        });
    }

    private String getTipId(String id) {
        return KEY_NAMESPACE + id;
    }
}

