/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.helptips;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugins.helptips.HelpTipManager;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class HelpTipDataProvider
implements WebResourceDataProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final HelpTipManager helpTipManager;

    public HelpTipDataProvider(JiraAuthenticationContext jiraAuthenticationContext, HelpTipManager helpTipManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.helpTipManager = helpTipManager;
    }

    public Jsonable get() {
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                try {
                    HelpTipDataProvider.this.getJsonData().write(writer);
                }
                catch (JSONException e) {
                    throw new Jsonable.JsonMappingException((Throwable)e);
                }
            }
        };
    }

    private JSONObject getJsonData() {
        HashMap values = Maps.newHashMap();
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (user != null) {
            Collection<String> dismissedTips = this.helpTipManager.getDismissedTips(user);
            values.put("dismissed", dismissedTips);
            values.put("anonymous", false);
        } else {
            values.put("anonymous", true);
        }
        return new JSONObject((Map)values);
    }
}

