/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav.newsletter;

import com.atlassian.fugue.Option;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.plugin.headernav.newsletter.NewsletterUserPreferencesManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class NewsletterSignupDataProvider
implements WebResourceDataProvider {
    private final JiraAuthenticationContext authenticationContext;
    private final NewsletterUserPreferencesManager newsletterUserPreferencesManager;
    private final HelpUrls helpUrls;
    private final I18nHelper i18nHelper;

    public NewsletterSignupDataProvider(JiraAuthenticationContext authenticationContext, NewsletterUserPreferencesManager newsletterUserPreferencesManager, HelpUrls helpUrls, I18nHelper i18nHelper) {
        this.authenticationContext = authenticationContext;
        this.newsletterUserPreferencesManager = newsletterUserPreferencesManager;
        this.helpUrls = helpUrls;
        this.i18nHelper = i18nHelper;
    }

    public Jsonable get() {
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                try {
                    NewsletterSignupDataProvider.this.getJsonData().write(writer);
                }
                catch (JSONException e) {
                    throw new Jsonable.JsonMappingException((Throwable)e);
                }
            }
        };
    }

    private JSONObject getJsonData() {
        HashMap values = Maps.newHashMap();
        ApplicationUser applicationUser = this.authenticationContext.getUser();
        Option user = Option.option((Object)applicationUser);
        values.put("showNewsletterTip", this.newsletterUserPreferencesManager.shouldShowSignupTip((Option<ApplicationUser>)user));
        values.put("formUrl", this.helpUrls.getUrl("newsletter.signup.form").getUrl());
        values.put("signupTitle", this.i18nHelper.getText("newsletter.signup.tip.title"));
        values.put("signupDescription", this.i18nHelper.getText("newsletter.signup.tip.description"));
        values.put("signupId", "newsletter-signup-tip");
        if (user.isDefined()) {
            values.put("userEmail", ((ApplicationUser)user.get()).getEmailAddress());
        }
        return new JSONObject((Map)values);
    }
}

