/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav;

import com.atlassian.jira.plugin.webfragment.JiraWebInterfaceManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserProfileContextProvider
implements ContextProvider {
    static final String SYSTEM_USER_OPTIONS = "system.user.options";
    static final String SECTIONS_KEY = "displayableSections";
    static final String SECTION_ITEMS_KEY = "completeSectionKeyToDisplayableItems";
    static final String HELP_WEB_SECTION_KEY = "jira-help";
    private final JiraAuthenticationContext authenticationContext;

    public UserProfileContextProvider(@Nonnull JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = (JiraAuthenticationContext)Assertions.notNull((Object)authenticationContext);
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ApplicationUser user = this.authenticationContext.getUser();
        JiraHelper helper = (JiraHelper)context.get("helper");
        JiraWebInterfaceManager webInterfaceManager = (JiraWebInterfaceManager)context.get("webInterfaceManager");
        List<WebSectionModuleDescriptor> displayableSections = this.collectDisplayableSections(user, helper, webInterfaceManager);
        Map<String, List> sectionsToDisplayableItems = this.collectDisplayableItemsForDisplayableSections(displayableSections, user, helper, webInterfaceManager);
        return MapBuilder.newBuilder(context).add((Object)SECTIONS_KEY, displayableSections).add((Object)SECTION_ITEMS_KEY, sectionsToDisplayableItems).toHashMap();
    }

    private List<WebSectionModuleDescriptor> collectDisplayableSections(@Nullable ApplicationUser user, @Nonnull JiraHelper helper, @Nonnull JiraWebInterfaceManager webInterfaceManager) {
        List displayableSections = webInterfaceManager.getDisplayableSections(SYSTEM_USER_OPTIONS, user, helper);
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)displayableSections, (Predicate)new Predicate<WebSectionModuleDescriptor>(){

            public boolean apply(@Nullable WebSectionModuleDescriptor webSection) {
                return webSection != null && !UserProfileContextProvider.HELP_WEB_SECTION_KEY.equals(webSection.getKey());
            }
        }));
    }

    @Nonnull
    private Map<String, List> collectDisplayableItemsForDisplayableSections(@Nonnull List<WebSectionModuleDescriptor> displayableSections, @Nonnull ApplicationUser user, @Nonnull JiraHelper helper, @Nonnull JiraWebInterfaceManager webInterfaceManager) {
        HashMap<String, List> sectionsToDisplayableItems = new HashMap<String, List>();
        for (WebSectionModuleDescriptor displayableSection : displayableSections) {
            String sectionKey = "system.user.options/" + displayableSection.getKey();
            List displayableItems = webInterfaceManager.getDisplayableItems(sectionKey, user, helper);
            sectionsToDisplayableItems.put(displayableSection.getCompleteKey(), displayableItems);
        }
        return sectionsToDisplayableItems;
    }
}

