/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarsDisabledException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AvatarUrlContextProvider
implements ContextProvider {
    static final String AVATAR_URL_KEY = "avatarUrl";
    static final Avatar.Size AVATAR_SIZE = Avatar.Size.NORMAL;
    private final AvatarService avatarService;
    private final JiraAuthenticationContext authenticationContext;

    public AvatarUrlContextProvider(@Nonnull AvatarService avatarService, @Nonnull JiraAuthenticationContext authenticationContext) {
        this.avatarService = (AvatarService)Assertions.notNull((Object)avatarService);
        this.authenticationContext = (JiraAuthenticationContext)Assertions.notNull((Object)authenticationContext);
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    @Nonnull
    public Map<String, Object> getContextMap(@Nullable Map<String, Object> context) {
        ApplicationUser user = this.authenticationContext.getUser();
        String url = this.getAvatarUrl(user);
        return Collections.singletonMap(AVATAR_URL_KEY, url);
    }

    @Nullable
    private String getAvatarUrl(@Nullable ApplicationUser user) {
        return this.getAvatarUrl(user, AVATAR_SIZE);
    }

    @Nullable
    private String getAvatarUrl(@Nullable ApplicationUser user, @Nonnull Avatar.Size size) {
        try {
            URI avatarURL = this.avatarService.getAvatarURL(user, user, size);
            return avatarURL != null ? avatarURL.toASCIIString() : null;
        }
        catch (AvatarsDisabledException e) {
            return null;
        }
    }
}

