define("jira-dashboard-items/lib/c3",["jira-dashboard-items/lib/d3","underscore"],function(d3,_){var c3={};c3.defaults={x:function(d){return d[0]},y:function(d){return d[1]}};c3.checkIsNumber=function(value){if(typeof value!=="number"){throw new Error("Expected a number, but received: "+value)}return value};c3.isEmpty=function(value){return !value||!value.length};c3.prop=function(defaultValue){var value=defaultValue;var getter=function(value){return value};var setter=function(newValue,oldValue){return newValue};function prop(newValue){if(arguments.length===0){return getter.call(this,value)}value=setter.call(this,newValue,value);return this}prop.get=function(newGetter){getter=newGetter;return this};prop.set=function(newSetter){setter=newSetter;return this};return prop};c3.inherit=function(from,defaultValue){var onDefault;var prop=c3.prop().get(function(value){if(value!=null){return value}for(var parent=this.parent();parent;parent=parent.parent()){if(typeof parent[from]==="function"){value=parent[from]();if(value!=null){return value}}}return onDefault?onDefault.call(this):defaultValue});prop.onDefault=function(fn){onDefault=fn;return this};return prop};c3.event=function(defaultHandler){var handlers=[];function bind(handler,context){handlers.push({handler:handler,context:context})}function emit(eventData){var emitContext=this;eventData=eventData||{};_.each(handlers,function(handlerEntry){handlerEntry.handler.call(handlerEntry.context||emitContext,eventData)});if(defaultHandler){defaultHandler.call(this,eventData)}}function event(){if(typeof arguments[0]==="function"){bind.apply(this,arguments)}else{emit.apply(this,arguments)}return this}event.off=function(handler,context){handlers=_.reject(handlers,function(handlerEntry){var matchesHandler=handler==null||handlerEntry.handler==handler;var matchesContext=context==null||handlerEntry.context==context;return matchesHandler&&matchesContext});return this};return event};c3.areaPlot=function(){return c3.component("areaPlot").extend(c3.drawable()).extend(c3.plottable()).elementTag("path").elementClass("area").dataFilter(function(data){return[data]}).extend({areaConstructor:c3.prop(d3.svg.area)}).update(function(event){var area=this.areaConstructor()().x(this.x());if(this.cartesian()){area.y0(this.height()).y1(this.y())}else{area.y0(this.y()).y1(0)}event.selection.attr("d",area(this.data()))})};c3.axis=function(){return c3.component("axis").extend(c3.plottable()).extend(function(){this.selection().call(this.axis())}).extend({axisConstructor:c3.inherit("axisConstructor",d3.svg.axis),orient:c3.prop("bottom"),horizontal:function(){var orient=this.orient();return orient==="bottom"||orient==="top"},axis:function(){var horizontal=this.horizontal();return this.axisConstructor().call(this).scale(horizontal?this.xScale():this.yScale()).orient(this.orient())}})};c3.borderLayout=function(){var region=function(){return c3.prop().set(function(component){return component.parent(this)})};var regionsDrawable=c3.drawable().extend({data:function(){return borderLayout.occupiedRegions()}}).dataKey(function(d){return d.name}).update(function(event){var positions=borderLayout.positions();event.selection.each(function(d){var regionContainer=d3.select(this);var position=positions[d.name];regionContainer.attr("transform","translate("+position.left+","+position.top+")");d.component.width(position.width).height(position.height);d.component(regionContainer)})});var borderLayout=c3.component("borderLayout").extend(c3.plottable()).extend(function(){regionsDrawable(this.selection())}).extend({center:region(),north:region(),south:region(),west:region(),east:region(),xRange:function(){return[0,this.centerWidth()]},yRange:function(){return[this.centerHeight(),0]},centerWidth:function(){return this.positions().center.width},centerHeight:function(){return this.positions().center.height},occupiedRegions:function(){var borderLayout=this;return _.compact(_.map(["north","south","west","east","center"],function(name){var component=borderLayout[name]();return component?{name:name,component:borderLayout[name]()}:null}))},positions:function(){var margins={top:c3.checkIsNumber(this.north()?this.north().height():0),bottom:c3.checkIsNumber(this.south()?this.south().height():0),left:c3.checkIsNumber(this.west()?this.west().width():0),right:c3.checkIsNumber(this.east()?this.east().width():0)};var layoutWidth=c3.checkIsNumber(this.width());var layoutHeight=c3.checkIsNumber(this.height());var positions={};var center=positions.center={left:margins.left,top:margins.top,width:layoutWidth-margins.left-margins.right,height:layoutHeight-margins.top-margins.bottom};if(this.north()){positions.north={top:margins.top,left:margins.left,height:margins.top,width:center.width}}if(this.south()){positions.south={top:layoutHeight-margins.bottom,left:margins.left,height:margins.bottom,width:center.width}}if(this.west()){positions.west={top:margins.top,left:margins.left,height:center.height,width:margins.left}}if(this.east()){positions.east={top:margins.top,left:layoutWidth-margins.right,height:center.height,width:margins.right}}return positions}});return borderLayout};c3.circlePlot=function(){return c3.component("circlePlot").extend(c3.drawable()).extend(c3.plottable()).elementTag("circle").update(function(event){event.selection.attr("cx",this.x()).attr("cy",this.y()).attr("r",this.radiusAccessor())}).extend({radiusAccessor:c3.prop(function(){return 4})})};c3.clippable=(function(){var clippingPathCounter=0;return function(){return c3.component("clippable").extend({clipped:c3.prop(false)}).extend(function(){if(!this.clipped()){return }var target=this;var clip=c3.singular().elementTag("clipPath").enter(function(event){var randomId="c3clip"+clippingPathCounter;clippingPathCounter++;target.selection().attr("clip-path","url(#"+randomId+")");event.selection.attr("id",randomId).append("rect").attr("x","0").attr("y","0").attr("fill","none")}).update(function(event){event.selection.select("rect").attr("width",target.width()).attr("height",target.height())});clip(this.selection())})}}());(function(figue){if(!figue){return }function _internalXAccessor(d){return d.point[0]}function _internalYAccessor(d){return d.point[1]}function _buildPointFromTree(tree){var point=_.extend({},{point:[this.xScale().invert(tree.centroid[0]),this.yScale().invert(tree.centroid[1])],size:tree.size,distance:tree.dist,isCluster:false});if(tree.left||tree.right){point.isCluster=true}point.label=_resolveAllChildLabels(tree);return point}function _resolveAllChildLabels(tree){var result=[];if(tree&&tree.label==-1){result.push.apply(result,_resolveAllChildLabels(tree.left));result.push.apply(result,_resolveAllChildLabels(tree.right))}else{result.push(tree.label)}return result}function _pruneAgglomerate(tree,clusteredResult,unclusteredResult){if(tree){if(tree.dist&&tree.dist>this.threshold()){_pruneAgglomerate.call(this,tree.left,clusteredResult,unclusteredResult);_pruneAgglomerate.call(this,tree.right,clusteredResult,unclusteredResult)}else{var point=_buildPointFromTree.call(this,tree);point.isCluster?clusteredResult.push(point):unclusteredResult.push(point)}}}function _updateClustering(){var clustered=[],unclustered=[];var x=this.x(),y=this.y();var vectorLabels=_.map(this.data(),this.labelAccessor());var scaledVectors=_.map(this.data(),function(element){return[x(element),y(element)]},this);var agglomerate=figue.agglomerate(vectorLabels,scaledVectors,figue.MAX_DISTANCE,figue.COMPLETE_LINKAGE);_pruneAgglomerate.call(this,agglomerate,clustered,unclustered);this.getLayer("clusteredLayer").data(clustered);this.getLayer("unclusteredLayer").data(unclustered)}c3.clusteredCirclePlot=function(){var clusteredCirclePlot=c3.component().extend({clustered:c3.prop([]),unclustered:c3.prop([]),clusterRadiusAccessor:c3.prop(function(){return 10}),singletonRadiusAccessor:c3.prop(function(){return 5})});clusteredCirclePlot.extend(_updateClustering).extend(c3.layerable().addLayer("clusteredLayer",c3.circlePlot().xAccessor(_internalXAccessor).yAccessor(_internalYAccessor).elementClass("cluster").radiusAccessor(function(elem){return clusteredCirclePlot.clusterRadiusAccessor()(elem)})).addLayer("unclusteredLayer",c3.circlePlot().xAccessor(_internalXAccessor).yAccessor(_internalYAccessor).elementClass("singleton").radiusAccessor(function(elem){return clusteredCirclePlot.singletonRadiusAccessor()(elem)})).extend({labelAccessor:c3.prop(function(element){return element.issue}),threshold:c3.prop(10)}));return clusteredCirclePlot}}(window.figue));c3.component=function(displayName){var mixins=[];function makeComponentFunction(){var component=function(selection){return component.applyTo(component,selection)};return component}var component=makeComponentFunction();function selectiveCopy(dest,src,exclude){for(var key in src){if(exclude&&key in exclude){continue}dest[key]=src[key]}return dest}var componentCommon={displayName:displayName,selection:c3.prop(null),parent:c3.prop(null),applyTo:function(base,selection){if(selection){component.selection(selection)}_.each(mixins,function(mixin){if(mixin.applyTo){mixin.applyTo(base,selection)}else{mixin.call(base,selection)}});return component},extend:function(mixable){if(typeof mixable==="function"){if(mixable.parent){mixable.parent(component)}mixins.push(mixable)}return selectiveCopy(component,mixable,componentCommon)}};return _.extend(component,componentCommon)};c3.deviationPlot=function(){return c3.component("deviationPlot").extend(c3.drawable()).extend(c3.plottable()).elementTag("path").elementClass("area").dataFilter(function(data){return[data]}).update(function(event){var yAccessor=this.yAccessor();var deviationAccessor=this.deviationAccessor();var yScale=this.yScale();var area=d3.svg.area().x(this.x()).y0(function(d){return yScale(yAccessor(d)+deviationAccessor(d))}).y1(function(d){return yScale(Math.max(yAccessor(d)-deviationAccessor(d),0))});event.selection.attr("d",area(this.data()))}).extend({deviationAccessor:c3.prop(function(d){return d[2]})})};c3.drawable=function(){return c3.component("drawable").extend(c3.withData()).extend(c3.withElements()).extend(function(){var binding=this.dataBinding();this.enter({selection:this.drawEnter(binding.enter())});this.exit({selection:this.drawExit(binding.exit())});this.update({selection:binding})}).extend({enter:c3.event(),exit:c3.event(),update:c3.event(),dataFilter:c3.prop(_.identity),dataBinding:function(){var data=this.dataFilter()(this.data());return this.elements().data(data,this.dataKey())},drawEnter:function(enter){var elements=enter.append(this.elementTag());var elementClass=this.elementClass();if(elementClass){elements.classed(elementClass,true)}return elements},drawExit:function(exit){return exit.remove()}})};c3.fitToParent=function(){return c3.component("fitToParent").extend({width:c3.prop(),height:c3.prop()}).extend(function(){var domParent=this.selection().node().domNode.parentElement;this.height(c3.checkIsNumber(domParent.clientHeight));this.width(c3.checkIsNumber(domParent.clientWidth))})};c3.gridLines=function(){return c3.component("gridLines").extend(c3.axis()).axisConstructor(function(){var tickSize;switch(this.orient()){case"left":tickSize=-this.width();break;case"right":tickSize=this.width();break;case"top":tickSize=-this.height();break;case"bottom":tickSize=this.height();break}return d3.svg.axis().tickSize(tickSize).tickFormat("")})};c3.ieDimensions=function(){if(document.documentMode&&document.documentMode<9){return c3.component("ieDimensions").extend(c3.fitToParent())}};c3.labelledAxis=function(){return c3.component("labelledAxis").extend(c3.axis()).extend({text:c3.prop("")}).extend(function(){var text=this.text();var label=c3.singular().elementTag("text").elementClass("axis-label").enter(function(event){event.selection.attr("text-anchor","middle")}).update(function(event){event.selection.text(text)});var labelElement=label(this.selection()).elements();var x=0,y=0,degrees=0;var bBox=labelElement.node().getBBox();switch(this.orient()){case"left":degrees=270;x=-1*this.width()+bBox.height;y=this.height()/2;break;case"right":degrees=90;x=this.width()-bBox.height;y=this.height()/2;break;case"top":degrees=0;x=this.width()/2;y=-1*this.height()+bBox.height;break;default:degrees=0;x=this.width()/2;y=this.height()-bBox.height/2}labelElement.attr("transform","translate("+x+", "+y+") rotate("+degrees+", 0, 0)")})};c3.layerable=function(){var layerDrawable=c3.drawable().elementClass("layer").update(function(event){event.selection.each(function(d,i){d.component(d3.select(this).classed(d.name,true))})});return c3.component("layerable").extend(function(){layerDrawable(this.selection())}).extend(c3.plottable()).extend({layers:function(){return layerDrawable.data()},getLayer:function(name){var layer=_.findWhere(this.layers(),{name:name});return layer?layer.component:undefined},addLayer:function(name,component){if(!this.getLayer(name)){this.layers().push({name:name,component:component.parent(this)})}return this},prependLayer:function(name,component){if(!this.getLayer(name)){this.layers().unshift({name:name,component:component.parent(this)})}return this},removeLayer:function(name){var layers=this.layers();var removed=_.reject(layers,function(layer){return layer.name===name});if(removed.length!==layers.length){this.layers(removed)}return this}})};c3.linePlot=function(){return c3.component("linePlot").extend(c3.drawable()).extend(c3.plottable()).elementTag("path").elementClass("line").dataFilter(function(data){return[data]}).extend({lineConstructor:c3.prop(d3.svg.line)}).update(function(event){var line=this.lineConstructor()().x(this.x()).y(this.y());event.selection.attr("d",line(this.data())).attr("stroke","black").attr("fill","none")})};c3.plottable=function(){return c3.component("plottable").extend(c3.withData()).extend(c3.withDimensions()).extend(c3.clippable()).extend({x:function(){var xScale=this.xScale();var xAccessor=this.xAccessor();return function(d,i){return xScale(xAccessor(d,i))}},y:function(){var yScale=this.yScale();var yAccessor=this.yAccessor();return function(d,i){return yScale(yAccessor(d,i))}},xAccessor:c3.inherit("xAccessor",c3.defaults.x),yAccessor:c3.inherit("yAccessor",c3.defaults.y),xScaleConstructor:c3.inherit("xScaleConstructor",d3.scale.linear),yScaleConstructor:c3.inherit("yScaleConstructor",d3.scale.linear),xDomain:c3.inherit("xDomain").onDefault(function(){if(c3.isEmpty(this.data())){return }var min=c3.checkIsNumber(d3.min(this.data(),this.xAccessor()));var max=c3.checkIsNumber(d3.max(this.data(),this.xAccessor()));return[min,max]}),yDomain:c3.inherit("yDomain").onDefault(function(){if(c3.isEmpty(this.data())){return }var min=c3.checkIsNumber(d3.min(this.data(),this.yAccessor()));var max=c3.checkIsNumber(d3.max(this.data(),this.yAccessor()));return[min,max]}),xRange:c3.inherit("xRange").onDefault(function(){var width=c3.checkIsNumber(this.width());return[0,width]}),yRange:c3.inherit("yRange").onDefault(function(){var height=c3.checkIsNumber(this.height());return this.cartesian()?[height,0]:[0,height]}),xScale:function(){return this.xScaleConstructor()().domain(this.xDomain()).range(this.xRange())},yScale:function(){return this.yScaleConstructor()().domain(this.yDomain()).range(this.yRange())},cartesian:c3.prop(true)})};c3.singular=function(){return c3.component("singular").extend(c3.withElements()).extend({enter:c3.event(),update:c3.event()}).extend(function(){var element=this.elements();if(!element.node()){element=this.selection().append(this.elementTag());if(this.elementClass()){element.classed(this.elementClass(),true)}this.enter({selection:element})}this.update({selection:element})})};c3.withData=function(){return c3.component("withData").extend({data:c3.inherit("data",[]),dataKey:c3.inherit("dataKey")})};c3.withDimensions=function(){return c3.component("withDimensions").extend({width:c3.inherit("width").onDefault(function(){return parseInt(this.selection().style("width"),10)||0}),height:c3.inherit("height").onDefault(function(){return parseInt(this.selection().style("height"),10)||0})})};c3.withElements=function(){return c3.component("withElements").extend({elementTag:c3.prop("g"),elementClass:c3.prop(""),elementSelector:function(){return this.elementClass()?this.elementTag()+"."+this.elementClass():this.elementTag()},elements:function(){var containerNode=this.selection().node();return this.selection().selectAll(this.elementSelector()).filter(function(){return this.parentNode===containerNode})}})};return c3});AJS.namespace("c3",null,require("jira-dashboard-items/lib/c3"));