define("jira-dashboard-items/createdvsresolved",["jira/util/formatter","wrm/context-path","jquery","jira/moment","jira-dashboard-items/createdvsresolved-config-view","jira-dashboard-items/components/charts/createdvsresolved-chart","jira-dashboard-items/components/charts/unresolved-trend-chart","jira-dashboard-items/common-functions","underscore"],function(formatter,wrmContextPath,$,moment,ConfigView,CreatedVsResolvedChart,UnresolvedTrendChart,DashboardHelperFunctions,_){var Templates=JIRA.DashboardItem.CreatedVsResolved.Templates;var PERIOD_I18N={hourly:formatter.I18n.getText("gadget.common.period.hourly"),daily:formatter.I18n.getText("gadget.common.period.daily"),weekly:formatter.I18n.getText("gadget.common.period.weekly"),monthly:formatter.I18n.getText("gadget.common.period.monthly"),quarterly:formatter.I18n.getText("gadget.common.period.quarterly"),yearly:formatter.I18n.getText("gadget.common.period.yearly")};var DashboardItem=function(API,options){this.API=API;this.options=options||{}};DashboardItem.prototype.renderEdit=function(element,preferences){var gadget=this;if(gadget.resizeHandler){$(element).removeResize(gadget.resizeHandler);delete gadget.resizeHandler}var dashboardPreferences=gadget._backwardCompatability(preferences);var configViewPreferences=gadget._dashboardToConfigViewPreferences(dashboardPreferences);$(".createdvsresolved-gadget",element).html(Templates.ConfigContainer());gadget.API.setTitle(formatter.I18n.getText("gadget.created.vs.resolved.title"));this.configView=new ConfigView({id:gadget.API.getGadgetId(),el:$(".createdvsresolved-config-container",element),projectFilterDelay:this.options.delay});this.configView.render(configViewPreferences);this.configView.bind("cancel",function(){gadget.API.closeEdit()});this.configView.bind("submit",function(gadgetPreferences){gadget.API.resize();var dashboardPreferences=gadget._configViewToDashboardPreferences(gadgetPreferences);gadget.API.savePreferences(dashboardPreferences).fail(function(message){if(message.status===401){gadget.configView.unauthorisedFormSave()}else{var errors=parseErrorMessage(message.responseText);gadget.configView.errorSavingForm(errors)}})});this.configView.bind("layoutUpdate",function(){gadget.API.resize()});this.API.once("afterRender",function(){if(element.width()<350){$(element).find("form.aui").addClass("top-label")}gadget.API.resize()})};DashboardItem.prototype.render=function(element,preferences){var gadget=this;var gadgetElement=$(".createdvsresolved-gadget",element);gadgetElement.html(Templates.RenderChart({showUnresolvedTrend:preferences.showUnresolvedTrend}));gadget.API.initRefresh(preferences,_.bind(gadget.render,gadget,element,preferences));gadget.API.showLoadingBar();preferences=gadget._backwardCompatability(preferences);var dateInfoRequest=this._requestDateData(preferences);$.when(dateInfoRequest).done(function(dateInfoResponse){gadget.API.hideLoadingBar();var formattedData=gadget._generateCreatedVsResolvedData(dateInfoResponse.results);var versionData=gadget._generateVersionData(preferences.type,preferences.versionLabel,dateInfoResponse.versions,formattedData.domain);gadget.initialRender=true;gadget._renderChart($(element).attr("id"),gadgetElement,preferences,dateInfoResponse,formattedData,versionData);gadget.resizeHandler=function(){if(gadget.initialRender){gadget.initialRender=false}else{_.bind(gadget._renderChart,gadget,$(element).attr("id"),gadgetElement,preferences,dateInfoResponse,formattedData,versionData)()}};$(element).resize(_.throttle(gadget.resizeHandler,600))}).fail(function(message){if(message.statusText==="timeout"){gadgetElement.html(JIRA.DashboardItem.CreatedVsResolved.Templates.Timeout())}else{if(message.status===400){var errors=parseErrorMessage(message.responseText);gadgetElement.html(JIRA.DashboardItem.CreatedVsResolved.Templates.Errors({errors:errors}))}else{gadgetElement.html(JIRA.DashboardItem.CreatedVsResolved.Templates.ServerError())}}gadget.API.hideLoadingBar();gadget.API.resize()})};DashboardItem.prototype._requestDateData=function(preferences){var dateInfoRequestData={jql:preferences.type+"="+preferences.id,period:preferences.periodName,daysprevious:preferences.daysprevious,operation:preferences.operation,field:["created","resolved"],includeVersions:preferences.versionLabel&&preferences.versionLabel!=="none"};if(preferences.showUnresolvedTrend){dateInfoRequestData.field.push("unresolvedTrend")}return $.ajax({method:"GET",url:wrmContextPath()+"/rest/gadget/1.0/dateCountInPeriod",dataType:"json",data:dateInfoRequestData})};DashboardItem.prototype._generateCreatedVsResolvedData=function(results){var domain=[];var createdValues=[];var resolvedValues=[];var unresolvedTrend=[];results.forEach(function(result){domain.push({start:result.start,end:result.end});createdValues.push(result.data.created);resolvedValues.push(result.data.resolved);if(result.data.unresolvedTrend){unresolvedTrend.push(result.data.unresolvedTrend.count)}});return{domain:domain,created:createdValues,resolved:resolvedValues,unresolvedTrend:unresolvedTrend}};DashboardItem.prototype._generateVersionData=function(type,versionsAllowed,versions,domain){var dashboardItem=this;var start=domain[0].start;var end=domain[domain.length-1].end;var data=[];versions.forEach(function(version){var hasReleaseDate=!!version.releaseDate;var isInRange=(start<=version.releaseDate)&&(version.releaseDate<=end);var isValidVersionName=dashboardItem._isValidVersionName(versionsAllowed,version.name);if(hasReleaseDate&&isInRange&&isValidVersionName){if(type==="filter"){version.name=version.project.key+":"+version.name}version.releaseDatePretty=moment(version.releaseDate).format("DD-MMM-YYYY");data.push([version.releaseDate,version])}});return _.sortBy(data,function(version){return version[0]})};function parseErrorMessage(errorString){var errorArray=[];try{var errorJSON=JSON.parse(errorString)}catch(error){return errorArray}for(var key in errorJSON){if(errorJSON.hasOwnProperty(key)){errorArray.push({key:key,message:errorJSON[key]})}}return errorArray}DashboardItem.prototype._backwardCompatability=function(gadgetPreferences){function isBlank(value){return value===null||value===undefined||value===""}if(!_.isUndefined(gadgetPreferences.isCumulative)&&isBlank(gadgetPreferences.operation)){if(gadgetPreferences.isCumulative){gadgetPreferences.operation="cumulative"}else{gadgetPreferences.operation="count"}delete gadgetPreferences.isCumulative}return DashboardHelperFunctions.projectFilterBackwardCompatible(gadgetPreferences)};DashboardItem.prototype._dashboardToConfigViewPreferences=function(dashboardPreferences){return{name:dashboardPreferences.name,id:dashboardPreferences.id,type:dashboardPreferences.type,periodName:dashboardPreferences.periodName,range:dashboardPreferences.daysprevious,operation:dashboardPreferences.operation,showUnresolvedTrend:dashboardPreferences.showUnresolvedTrend,versionLabel:dashboardPreferences.versionLabel,refresh:dashboardPreferences.refresh,isConfigured:dashboardPreferences.isConfigured}};DashboardItem.prototype._configViewToDashboardPreferences=function(configViewPreferences){var refresh=false;if(configViewPreferences.refresh===true){refresh="15"}return{name:configViewPreferences.name,id:configViewPreferences.id,type:configViewPreferences.type,periodName:configViewPreferences.periodName,daysprevious:configViewPreferences.range,operation:configViewPreferences.operation,showUnresolvedTrend:configViewPreferences.showUnresolvedTrend,versionLabel:configViewPreferences.versionLabel,refresh:refresh}};DashboardItem.prototype._isValidVersionName=function(versionsAllowed,version){return versionsAllowed==="all"||versionsAllowed==="major"&&!this._isMinorVersion(version)};DashboardItem.prototype._isMinorVersion=function(version){if(version){var numberOfVersionSeparators=(version.match(/\./g)||[]).length;var isAlphaOrBetaVersion=version.indexOf("alpha")>=0||version.indexOf("beta")>=0;return numberOfVersionSeparators>1||isAlphaOrBetaVersion}return false};DashboardItem.prototype._renderChart=function(id,gadgetElement,preferences,dateInfoResponse,formattedData,versionData){var gadget=this;var createdVsResolvedChartContainer=gadgetElement.find(".createdvsresolved-chart-container");var containerWidth=createdVsResolvedChartContainer.outerWidth();var containerHeight=containerWidth*2/3;var createdVsResolvedChartHeight=preferences.showUnresolvedTrend?containerHeight*3/4:containerHeight+20;var trendChartHeight=Math.max(containerHeight/4,80);var createdVsResolvedOptions={id:id,data:formattedData,versionData:versionData,el:createdVsResolvedChartContainer,filterUrl:dateInfoResponse.filterUrl,axisOptions:{includeXAxis:true,includeYAxis:true},cumulative:preferences.operation==="cumulative",days:preferences.daysprevious,period:preferences.periodName,chartHeight:createdVsResolvedChartHeight};var createdVsResolvedChart=new CreatedVsResolvedChart(createdVsResolvedOptions);createdVsResolvedChart.render();if(preferences.showUnresolvedTrend){var unresolvedTrendChart=new UnresolvedTrendChart({el:gadgetElement.find(".unresolvedtrend-chart-container").get(0),id:id,data:formattedData.unresolvedTrend,domain:formattedData.domain,versionData:versionData,period:preferences.periodName,chartHeight:trendChartHeight,axisOptions:{includeXAxis:true,includeYAxis:true}});unresolvedTrendChart.render()}var chartInfoContainer=gadgetElement.find(".createdvsresolved-chart-info");chartInfoContainer.html(Templates.ChartDetailsContent({createdCount:dateInfoResponse.totals.created,resolvedCount:dateInfoResponse.totals.resolved,dayCount:JIRA.NumberFormatter.format(parseInt(preferences.daysprevious)),period:PERIOD_I18N[preferences.periodName],filterUrl:dateInfoResponse.filterUrl}));gadget.API.setTitle(formatter.I18n.getText("gadget.created.vs.resolved.title.specific",dateInfoResponse.filterTitle));gadget.API.resize()};return DashboardItem});