define("jira-dashboard-items/bubble-chart-model",["jira/util/formatter","wrm/context-path","jquery","underscore","backbone","jira-dashboard-items/components/charts/components/relative-distribution","jira-dashboard-items/lib/d3"],function(formatter,wrmContextPath,$,_,Backbone,RelativeDistribution,d3){var BubbleChartModel=Backbone.Model.extend({urlRoot:wrmContextPath()+"/rest/gadget/1.0/bubblechart",defaults:{useLogarithmicScale:false,useRelativeColoring:true,colors:["#28892C","#95B436","#F5C342","#F1A256","#F79232","#D04436"],issueLimit:200,sizeAxis:"participants"},url:function(){return this.urlRoot+"/generate?projectOrFilterId="+this.get("projectOrFilterId")+"&bubbleType="+this.get("bubbleType")+"&recentCommentsPeriod="+this.get("recentCommentsPeriod")},parse:function(response){var parsed={};parsed.keyLabel=formatter.I18n.getText("bubble-chart.key.axis.title.label");parsed.xAxisLabel=formatter.I18n.getText("bubble-chart.x.axis.title.label");parsed.yAxisLabel=formatter.I18n.getText("bubble-chart.y.axis.title.label");parsed.sizeAxisLabel=this.get("bubbleType")==="participants"?formatter.I18n.getText("bubble-chart.participants"):formatter.I18n.getText("bubble-chart.votes");parsed.colorAxisLabel=formatter.I18n.getText("bubble-chart.color.axis.title.label");parsed.filterTitle=response.filterTitle;parsed.issueCount=response.issueCount;var data=response.data;if(this.get("useLogarithmicScale")){data=this._filterZeroesForLogarithmicScale(data)}if(response.warning&&response.issueCount>=this.get("issueLimit")||data.length>this.get("issueLimit")){parsed.exceedsIssueLimit=true}else{parsed.exceedsIssueLimit=false}parsed.colorDomain=this.get("useRelativeColoring")?this._domainForRelativeColorDistribution(data):this._domainForAbsoluteColorDistribution(data);parsed.legendData=this.get("useRelativeColoring")?this._legendDataForRelativeColoring(this.get("colors")):this._legendDataForAbsoluteColoring(this.get("colors"));parsed.data=data;return parsed},getIssueForIssueKey:function(issueKey){return _.findWhere(this.get("data"),{key:issueKey})},indexInDomainForValue:function(value){var scale=d3.scale.quantile().domain(this.get("colorDomain")).range(this.get("colors"));return this.get("colors").indexOf(scale(value))},_domainForAbsoluteColorDistribution:function(chartData){var min=d3.min(chartData,function(d){return d.bubbleColorValue});var max=d3.max(chartData,function(d){return d.bubbleColorValue});return[min,max]},_domainForRelativeColorDistribution:function(chartData){var colorValues=chartData.map(function(dataPoint){return dataPoint.bubbleColorValue});var distribution=RelativeDistribution.distribute(colorValues,[0.1,0.2,0.4,0.2,0.1]);return distribution.map(function(arr){return arr[0]}).filter(Number)},_filterZeroesForLogarithmicScale:function(chartData){return chartData.filter(function(dataPoint){return dataPoint.bubbleDomain!==0&&dataPoint.bubbleRange!==0})},_legendDataForRelativeColoring:function(colors){var legendData=colors.map(function(_,i){return""});legendData[0]=formatter.I18n.getText("bubble-chart.legend.low");legendData[legendData.length-1]=formatter.I18n.getText("bubble-chart.legend.high");return legendData},_legendDataForAbsoluteColoring:function(colors){return this._legendDataForRelativeColoring(colors)}});return BubbleChartModel});