define("jira-dashboard-items/bubble-chart",["jira/util/formatter","jquery","underscore","backbone","jira-dashboard-items/components/charts/bubble-chart/bubble-chart-component","jira-dashboard-items/bubble-chart-model","jira-dashboard-items/components/charts/components/discrete-legend/discrete-legend"],function(formatter,$,_,Backbone,BubbleChartComponent,BubbleChartModel,DiscreteLegend){var BubbleChart=Backbone.View.extend({template:JIRA.DashboardItem.BubbleChart.Templates,initialize:function(options){this.RESIZE_RATE_LIMIT=300;this.setTitle=options.setTitle;this.hideLoadingBar=options.hideLoadingBar;this.resize=options.resize;this.discreteLegendModel=new Backbone.Model({data:options.model.get("legendData"),colors:options.model.get("colors")});this.listenTo(options.model,{"change:legendData":function(model,data){this.discreteLegendModel.set("data",data)},"change:colors":function(model,colors){this.discreteLegendModel.set("colors",colors)}})},render:function(){this.listenTo(this.model,{"change:data":this._renderBubbleChart,"change:filterTitle":function(model,filterTitle){this.setGadgetTitleForFilter(filterTitle)},"change:highlightedCircle":function(model,options){this.discreteLegendModel.set("highlightedSegment",options.colorBucket)},"change:selectedCircle":function(model,options){this.discreteLegendModel.set("selectedSegment",options?options.colorBucket:undefined)}});this.resizeHandler=_.debounce(this._renderBubbleChart.bind(this),this.RESIZE_RATE_LIMIT);$(window).resize(this.resizeHandler);this.$el.on("remove",function(){$(window).off("resize",this.resizeHandler)}.bind(this))},_renderBubbleChart:function(){this._removeExistingBubbleChartIfItExists();this.hideLoadingBar();var data=this.model.get("data");if(!data){return }if(data&&data.length===0){this._displayNoDataInfoMessage();return }var bubbleType=this.model.get("bubbleType");var displayWarning=this.model.get("exceedsIssueLimit");this.$el.html(this.template.Container({type:this.model.get("bubbleType"),displayWarning:displayWarning}));var $bubbleChartContainer=this.$(".bubble-chart-component-container");this.bubbleChart=this._createBubbleChart($bubbleChartContainer,this.model.get("data"),this.model.get("colors"));this.bubbleChart.render();var $legendElement=this.$(".discrete-legend-component-container");var graphWidth=$(".graph-border",$bubbleChartContainer).attr("width");var graphHeight=$(".graph-border",$bubbleChartContainer).attr("height");$legendElement.attr("width",graphWidth);$legendElement.attr("height",graphHeight);this.legend=this._createLegend($legendElement.get(0));this.legend.render();this.resize();this.setGadgetTitleForFilter(this.model.get("filterTitle"))},_removeExistingBubbleChartIfItExists:function(){if(this.bubbleChart){this.bubbleChart.stopListening();this.bubbleChart.$el.remove();this.bubbleChart=null}},_displayNoDataInfoMessage:function(){this.setTitle(formatter.I18n.getText("bubble-chart-title.config"));this.$el.html(this.template.NoDataInfo());this.resize()},_createBubbleChart:function(element){return new BubbleChartComponent({model:this.model,el:element,id:this.id})},_createLegend:function(element){return new DiscreteLegend({el:element,model:this.discreteLegendModel})},setGadgetTitleForFilter:function(filterTitle){this.setTitle(formatter.I18n.getText("bubble-chart.title.filterorproject",filterTitle))}});return BubbleChart});