define("jira-dashboard-items/components/charts/piechart",["jquery","jira-dashboard-items/lib/d3"],function($,d3){function DEFAULT_COLOUR_PICKER(colours,numberElements){var LIME_GREEN="#8eb021";var BLUE="#3b7fc4";var RED="#d04437";var YELLOW="#f6c342";var VIOLET="#654982";var PINK="#f691b2";var GRAY="#999999";var ASH_GRAY="#cccccc";var BROWN="#815b3a";var CHEETO_ORANGE="#f79232";var TAN="#f1a257";var LIGHT_BROWN="#d39c3f";var CYAN="#59afe1";var SLATE="#4a6785";var COOL_BLUE="#84bbc6";var MID_GREEN="#67ab49";var MAUVE="#ac707a";var BRIGHT_PINK="#f15c75";colours=colours||[LIME_GREEN,BLUE,RED,YELLOW,VIOLET,PINK,GRAY,BROWN,CHEETO_ORANGE,CYAN,BRIGHT_PINK];function getNextColour(piechart,data,index,sectorElement){var colourIndex=index%colours.length;var isLast=(index+1===numberElements);var isFirstColour=(colourIndex===0);var oneSector=(numberElements===1);if(isLast&&isFirstColour&&!oneSector){colourIndex=1}return colours[colourIndex]}return getNextColour}function noop(){}var PieChart=function(data,options){this.radius=options.radius;this.data=data;this.getValue=options.getValue||function(dataElement){return dataElement};this.centerChart=options.centerChart||false;this.clickable=options.clickable||false;this.colourPicker=options.colourPicker||DEFAULT_COLOUR_PICKER(options.colours,this.data.length);this.hoverExpansion=options.hoverExpansion||0;this.innerRadius=options.innerRadius||0;this.sectorGap=options.sectorGap||2;this.innerCirclePadding=Math.min(10,Math.max(this.innerRadius,0));this.getPrimaryText=options.getPrimaryText||noop;this.getSecondaryText=options.getSecondaryText||noop;this.onClick=options.onClick||noop;this.onEachArc=options.onEachArc||noop;this.onMouseOver=options.onMouseOver||noop;this.onMouseOut=options.onMouseOut||noop;this.pieCenter=this.radius+this.hoverExpansion;this.width=this.pieCenter*2;this.height=this.pieCenter*2;this.render=function(element){var self=this;var chart=d3.select(element[0]).append("svg").data([this.data]).classed({piechart:true,centered:this.centerChart}).attr("width",this.width).attr("height",this.height);chart.append("g").classed({"piechart-graph":true}).attr("transform","translate("+this.pieCenter+","+this.pieCenter+")");var centerTextBlockOptions={width:2*(this.innerRadius-this.innerCirclePadding),height:Math.sqrt(2*this.innerRadius*this.innerRadius),dx:(this.pieCenter-this.innerRadius+this.innerCirclePadding),dy:(this.pieCenter-this.innerRadius+2*this.innerCirclePadding)};var arc=d3.svg.arc().outerRadius(this.radius).innerRadius(this.innerRadius);var arcLarger=d3.svg.arc().outerRadius(this.radius+this.hoverExpansion).innerRadius(this.innerRadius);var pie=d3.layout.pie().value(this.getValue);this.arcs=chart.select("g.piechart-graph").selectAll("g").data(pie).enter().append("g").classed({"piechart-arc":true,clickable:this.clickable}).each(function(sector,index){self.onEachArc(self,sector.data,index,$(d3.select(this).node()))});this.arcs.append("text").attr("width",centerTextBlockOptions.width).attr("text-anchor","middle").classed("piechart-center-primary",true).attr("y",5).attr("fill",function(sector,index){return self.colourPicker(self,sector.data,index,d3.select(this).node())}).text(function(sector,index){return self.getPrimaryText(sector.data,index)});this.arcs.append("text").attr("width",centerTextBlockOptions.width).attr("text-anchor","middle").classed("piechart-center-secondary",true).attr("fill","#333333").attr("y",25).text(function(sector,index){return self.getSecondaryText(sector.data,index)});this.arcs.append("path").attr("stroke","#fff").attr("stroke-width",this.sectorGap).attr("fill",function(sector,index){return self.colourPicker(self,sector.data,index,d3.select(this).node())}).classed({"piechart-fill":true}).attr("d",arc);this.arcs.on("click",function(sector,index){self.onClick(self,sector.data,index,d3.select(this).node())});this.mouseOver=function(dataIndex){_mouseOver.call(this.arcs[0][dataIndex],this.arcs.data()[dataIndex],dataIndex)};this.mouseOut=function(dataIndex){_mouseOut.call(this.arcs[0][dataIndex],this.arcs.data()[dataIndex],dataIndex)};var _mouseOver=function(sector,index){d3.select(this).classed({"piechart-arc-highlighted":true});d3.select(this).select("path").transition().duration(100).attr("d",arcLarger);self.onMouseOver(self,sector.data,index,d3.select(this).node())};var _mouseOut=function(sector,index){d3.select(this).classed({"piechart-arc-highlighted":false});d3.select(this).select("path").transition().duration(100).attr("d",arc);self.onMouseOut(self,sector.data,index,d3.select(this).node())};this.arcs.on("mouseover",function(sector,index){_mouseOver.call(this,sector,index)});this.arcs.on("mouseout",function(sector,index){_mouseOut.call(this,sector,index)})}};return PieChart});