define("jira-dashboard-items/components/charts/bubble-chart/bubble-chart-component",["wrm/context-path","jquery","backbone","jira-dashboard-items/components/charts/components/chart","jira-dashboard-items/components/charts/components/colored-circle-plot","jira-dashboard-items/lib/d3","jira-dashboard-items/lib/c3"],function(wrmContextPath,$,Backbone,Chart,ColoredCirclePlot,d3,c3){var BubbleChartComponent=Backbone.View.extend({template:JIRA.DashboardItem.BubbleChartComponent.Templates.Container,initialize:function(options){this.options=options||{};this.colors=options.colors||["red","blue"];this.model=options.model;this.xAxisTitleLabel=this.model.get("xAxisLabel");this.yAxisTitleLabel=this.model.get("yAxisLabel");this.xScaleConstructor=(this.model.get("useLogarithmicScale"))?d3.scale.log:d3.scale.linear;this.yScaleConstructor=(this.model.get("useLogarithmicScale"))?d3.scale.log:d3.scale.linear;this.AMOUNT_TO_INCREASE_CHART_TO_PREVENT_CLIPPING=10;this.X_TITLE_LABEL_BUFFER=25;this.HOVER_STATE_CLASS_NAME="hovered";this.SELECTED_CIRCLE_CLASS="selected";this.BACKING_CIRCLE_CLASS="backing";this.TOOLTIP_DELAY_APPEAR_TIME=0;this.TOOLTIP_CLASS="bubble-chart-component-tooltip";this.inlineDialog=null},render:function(){var documentClick=this._handleDocumentClick.bind(this);var showLayer=this._handleShowLayer.bind(this);$(document).on("click",documentClick);$(document).on("showLayer",showLayer);this.$el.on("remove",function(){$(document).off("click",documentClick);$(document).off("showLayer",showLayer)}.bind(this));this.listenTo(this.model,{"change:highlightedCircle":this._changeHighlight,"change:selectedCircle":this._changeSelection});this.$el.html(this.template({id:this.options.id}));var bubblePlot=this._createBubblePlot();var bubblePlotGraph=c3.layerable().data(this.model.get("data")).addLayer("bubble-plot",bubblePlot);var chart=this._createChart(bubblePlotGraph);var $chartElement=this.$(".bubble-chart-component-plot");this._setInitialHeightOfChart($chartElement);var svg=d3.select($chartElement.get(0));svg.call(chart);this._preventClippingTheTopMostLabelOnYAxis($chartElement);this._addGridLinesToChart($chartElement);this._removeTicksWithoutText($chartElement)},_circleForIssueKey:function(issueKey){return this.$('circle:data("'+issueKey+'")').get(0)},_removeAllBackingCircles:function(){this.$("circle."+this.BACKING_CIRCLE_CLASS).remove()},_handleDocumentClick:function(){if((!this.model.get("highlightedCircle")||!this.model.get("highlightedCircle").issueKey)){if(this.model.get("selectedCircle")&&this.model.get("selectedCircle").issueKey){this._removeSelectedClassFromAllCircles();this.model.unset("selectedCircle")}}},_handleShowLayer:function(e,n,target){if(target.popup&&(target.popup.dashboardItemId!==this.options.id)&&this.inlineDialog){this.model.unset("selectedCircle")}},_changeHighlight:function(model,selection){if(!selection.issueKey){d3.selectAll("."+this.HOVER_STATE_CLASS_NAME).classed(this.HOVER_STATE_CLASS_NAME,false).attr("r",function(){return Number(d3.select(this).attr("r"))-1});return }var circle=this._circleForIssueKey(selection.issueKey);var radius=Number(d3.select(circle).attr("r"));d3.select(circle).classed(this.HOVER_STATE_CLASS_NAME,true);d3.select(circle).attr("r",radius+1);this._positionToolTipForCircle(circle,selection.index)},_changeSelection:function(model,selection){if(this.inlineDialog){this.inlineDialog.hide();this.inlineDialog=undefined}this._removeAllBackingCircles();if(!selection){return }this._removeSelectedClassFromAllCircles();var circle=this._circleForIssueKey(selection.issueKey);$(circle).tipsy("hide");this._addBackingCircleForSelectedCircle(circle);model.set("isSelectedCircleInTopColorBucket",selection.isTopColorBucket);var issue=model.getIssueForIssueKey(selection.issueKey);var inlineDialogContent=this._createInlineDialogContent(selection.issueKey,issue.bubbleDomain,issue.bubbleRange,issue.bubbleRadius,issue.bubbleColorValue);var newInlineDialog=this._createInlineDialog($(circle),"bubble-chart-dialog-"+selection.issueKey,inlineDialogContent);this.inlineDialog=newInlineDialog;this.inlineDialog.show()},_removeSelectedClassFromAllCircles:function(){d3.select(this.el).selectAll("circle."+this.SELECTED_CIRCLE_CLASS).classed(this.SELECTED_CIRCLE_CLASS,false)},_removeTicksWithoutText:function($chartElement){var tickGroups=$chartElement.find("g.tick");tickGroups.each(function(index){var textContent=$("text",this).text();if(textContent===""){$(this).remove()}})},_preventClippingTheTopMostLabelOnYAxis:function($chartElement){var increase=this.AMOUNT_TO_INCREASE_CHART_TO_PREVENT_CLIPPING;$chartElement.children("g").each(function(i,el){d3.select(el).attr("transform",function(){var originalX=d3.transform(d3.select(el).attr("transform")).translate[0];var originalY=d3.transform(d3.select(el).attr("transform")).translate[1];var shiftedY=originalY+increase;return"translate("+originalX+", "+shiftedY+")"})});$chartElement.height("+="+increase)},_addGridLinesToChart:function($chartElement){var xAxisTickGroups=$chartElement.find(".xAxis g.tick");var graph=d3.select($chartElement.get(0)).select(".graph");var xAxis=$chartElement.find(".xAxis").get(0);var graphWidth=$chartElement.find(".graph-border").attr("width");var graphHeight=$chartElement.find(".graph-border").attr("height");var gridTickClass="grid-tick";var yAxisTickGroups=$chartElement.find(".yAxis g.tick");addValueTickClassToGroups(xAxisTickGroups);addValueTickClassToGroups(yAxisTickGroups);this._addVerticalGridLines(xAxisTickGroups,-graphHeight,gridTickClass);this._addHorizontalGridLines(yAxisTickGroups,graphWidth,gridTickClass);function addValueTickClassToGroups(groups){var valueTickClass="value-tick";d3.selectAll(groups).selectAll("line").classed(valueTickClass,true)}},_addHorizontalGridLines:function(yAxisTickGroups,xAxisWidth,gridTickClass){return d3.selectAll(yAxisTickGroups).append("line").attr("x2",xAxisWidth).classed(gridTickClass,true)},_addVerticalGridLines:function(xAxisTickGroups,yAxisHeight,gridTickClass){return d3.selectAll(xAxisTickGroups).append("line").attr("y2",yAxisHeight).attr("x2",0).classed(gridTickClass,true)},_setInitialHeightOfChart:function($chartElement){var width=this.$el.width();$chartElement.width(width);$chartElement.height(width*0.5)},_createChart:function(graph){var chart=c3.borderLayout().xAccessor(function(d){return d.bubbleDomain}).yAccessor(function(d){return d.bubbleRange});var content=this._createGraphContentLayer(graph);var xAxis=this._createXAxis();var yAxis=this._createYAxis();chart.center(content);chart.west(yAxis);chart.south(xAxis);return chart.data(this.model.get("data"))},_createXAxis:function(){return c3.labelledAxis().orient("bottom").height(this.X_TITLE_LABEL_BUFFER*2).extend(function(){this.selection().classed("xAxis",true)}).xAccessor(function(d){return d.bubbleDomain}).xScaleConstructor(this.xScaleConstructor).axisConstructor(function(){return d3.svg.axis().ticks(4,",d")}).text(this.xAxisTitleLabel)},_createYAxis:function(){return c3.labelledAxis().orient("left").width(60).extend(function(){this.selection().classed("yAxis",true)}).yAccessor(function(d){return d.bubbleRadius}).yScaleConstructor(this.yScaleConstructor).axisConstructor(function(){return d3.svg.axis().ticks(5,",d")}).text(this.yAxisTitleLabel)},_createGraphContentLayer:function(graph){return c3.layerable().extend(function(){this.selection().classed("graph",true)}).addLayer("graph",graph)},_tooltipTitleSpanIdForIndex:function(index){return"bubble-chart-"+this.options.id+"-tooltip-"+index},_addTooltipsToCircles:function(data,titleAccessor,radius){var backboneView=this;this.$("circle").each(function(index,element){$(element).tooltip({html:true,title:function(){var spanId=backboneView._tooltipTitleSpanIdForIndex(index);return'<span id="'+spanId+'">'+titleAccessor(data[index])+"</span>"},trigger:"manual",gravity:"w",className:backboneView.TOOLTIP_CLASS})})},_addClipToHideCirclesOutsideBorder:function(containerSelection,width,height){var clipId="bubble-chart-component-clip-"+this.options.id;d3.select(this.$("g.layer.graph").get(0)).insert("defs").append("svg:clipPath").attr("id",clipId).append("rect").attr("width",width).attr("height",height);containerSelection.attr("clip-path","url(#"+clipId+")")},_addBorderToFrameOfSize:function(width,height){d3.select(this.$("g.layer.graph").get(0)).insert("rect").classed("graph-border",true).attr("width",width).attr("height",height)},_createBubblePlot:function(){var backboneView=this;return ColoredCirclePlot().extend(function(){backboneView._addTooltipsToCircles(backboneView.model.get("data"),this.titleAccessor(),this.radius());backboneView._addClipToHideCirclesOutsideBorder(this.selection(),this.width(),this.height());backboneView._addBorderToFrameOfSize(this.width(),this.height())}).xScaleConstructor(this.xScaleConstructor).yScaleConstructor(this.yScaleConstructor).xAccessor(function(d){return d.bubbleDomain}).yAccessor(function(d){return d.bubbleRange}).radiusAccessor(function(d){return d.bubbleRadius}).colorAccessor(function(d){return d.bubbleColorValue}).update(function(event,d){var titleAccessor=this.titleAccessor();event.selection.each(function(d,i){$(this).data(titleAccessor(d),"true")}).on("click",this.click()).on("mouseenter",this.mouseenter()).on("mouseleave",this.mouseleave())}).extend({colorScaleConstructor:c3.inherit("colorScaleConstructor",d3.scale.quantile),colorRange:c3.inherit("colorRange").onDefault(function(){return backboneView.model.get("colors")}),colorDomain:c3.inherit("colorDomain").onDefault(function(){return backboneView.model.get("colorDomain")}),titleAccessor:c3.prop(function(data){return data.key}),xRange:function(){var width=c3.checkIsNumber(this.width());var largestCircleRadius=c3.checkIsNumber(d3.max(backboneView.model.get("data"),this.radius()));return[0,width-largestCircleRadius-5]},yRange:function(){var height=c3.checkIsNumber(this.height());var largestCircleRadius=c3.checkIsNumber(d3.max(backboneView.model.get("data"),this.radius()));return[height,largestCircleRadius+5]},click:function(){var titleAccessor=this.titleAccessor();var colorConstructor=this.color();var colorRange=this.colorRange();return function(data){var indexInRange=colorRange.indexOf(colorConstructor(data));AJS.trigger("analyticsEvent",{name:"jira.dashboard.gadgets.bubble-chart.bubble-clicked",data:{colorBucket:indexInRange}});backboneView.model.set("selectedCircle",{issueKey:titleAccessor(data),colorBucket:indexInRange,isTopColorBucket:indexInRange===colorRange.length-1})}},mouseenter:function(){var colorRange=this.colorRange();var color=this.color();var titleAccessor=this.titleAccessor();return function(data,index){var indexInRange=colorRange.indexOf(color(data));$(this).tipsy("show");backboneView.model.set("highlightedCircle",{issueKey:titleAccessor(data),colorBucket:indexInRange,index:index})}},mouseleave:function(){return function(){$(this).tipsy("hide");backboneView.model.set("highlightedCircle",{issueKey:undefined,colorBucket:undefined})}}})},_positionToolTipForCircle:function(circle,index){setTimeout(function(){var spanId=this._tooltipTitleSpanIdForIndex(index);var $tooltip=$("#"+spanId).parent().parent();var circleRadius=Number($(circle).attr("r"));var heightOfTooltip=20;var circleLeft=circle.getBoundingClientRect().left+window.pageXOffset;var circleTop=circle.getBoundingClientRect().top+window.pageYOffset;$tooltip.css({top:circleTop+circleRadius-heightOfTooltip,left:circleLeft+2*circleRadius});d3.select($tooltip.get(0)).classed(this.TOOLTIP_CLASS,false)}.bind(this),this.TOOLTIP_DELAY_APPEAR_TIME+10)},_createInlineDialogContent:function(key,x,y,radius,color){return JIRA.DashboardItem.BubbleChartComponent.Templates.InlineDialog({url:wrmContextPath()+"/browse/"+key,title:key,x:x,xLabel:this.model.get("xAxisLabel"),y:y,yLabel:this.model.get("yAxisLabel"),radius:radius,radiusLabel:this.model.get("sizeAxisLabel"),color:color,colorLabel:this.model.get("colorAxisLabel"),isTopColorBucket:this.model.get("isSelectedCircleInTopColorBucket")})},_createInlineDialog:function(trigger,id,content){var dialogPadding=10;var dialogWidth=350;var dialog=AJS.InlineDialog($(trigger),id,function(element,trigger,showPopup){element.addClass("bubble-chart-inline-dialog");element.css({padding:dialogPadding+"px"});element.html(content);showPopup();return false},{hideDelay:60000,gravity:"w",cacheContent:false,width:dialogWidth,fadeTime:0});dialog.dashboardItemId=this.options.id;return dialog},_addBackingCircleForSelectedCircle:function(circle){var backingCircle=circle.cloneNode(true);var currentRadius=Number($(backingCircle).attr("r"));d3.select(circle).classed(this.SELECTED_CIRCLE_CLASS,true);d3.select(backingCircle).classed(this.BACKING_CIRCLE_CLASS,true);$(backingCircle).attr("r",currentRadius+3);$(circle).before(backingCircle)}});return BubbleChartComponent});