/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.whitelist;

import com.atlassian.jira.bc.portal.GadgetApplinkUpgradeUtil;
import com.atlassian.jira.bc.whitelist.WhitelistManager;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class UpgradeTask_Build611
implements PluginUpgradeTask {
    private final GadgetApplinkUpgradeUtil gadgetApplinkUpgradeUtil;
    private final WhitelistManager whitelistManager;

    @Autowired
    public UpgradeTask_Build611(@ComponentImport GadgetApplinkUpgradeUtil gadgetApplinkUpgradeUtil, @ComponentImport WhitelistManager whitelistManager) {
        this.gadgetApplinkUpgradeUtil = gadgetApplinkUpgradeUtil;
        this.whitelistManager = whitelistManager;
    }

    public Collection<Message> doUpgrade() {
        if (this.whitelistManager.getRules().isEmpty()) {
            Map externalGadgets = this.gadgetApplinkUpgradeUtil.getExternalGadgetsRequiringUpgrade();
            ArrayList<String> rules = new ArrayList<String>();
            rules.add("http://www.atlassian.com/*");
            if (!externalGadgets.isEmpty()) {
                for (URI uri : externalGadgets.keySet()) {
                    rules.add(uri.normalize().toASCIIString().toLowerCase() + "/*");
                }
            }
            this.updateWhitelist(rules);
        }
        return Collections.emptySet();
    }

    public String getShortDescription() {
        return "Configuring whitelist entries for all external gadgets";
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getPluginKey() {
        return "com.atlassian.jira.gadgets";
    }

    private void updateWhitelist(List<String> rules) {
        try {
            ImportUtils.setSubvertSecurityScheme((boolean)true);
            this.whitelistManager.updateRules(rules, false);
        }
        finally {
            ImportUtils.setSubvertSecurityScheme((boolean)false);
        }
    }
}

