/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.whitelist;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.event.AddGadgetEvent;
import com.atlassian.gadgets.event.AddGadgetFeedEvent;
import com.atlassian.jira.bc.whitelist.InternalWhitelistManager;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.whitelist.ImmutableWhitelistRule;
import com.atlassian.plugins.whitelist.LegacyWhitelistRule;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistService;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={InternalWhitelistManager.class})
@Component
public class DefaultWhitelistManager
implements InternalWhitelistManager,
InitializingBean,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final WhitelistService whitelistService;
    private final OutboundWhitelist whitelist;

    @Autowired
    public DefaultWhitelistManager(@ComponentImport EventPublisher eventPublisher, @ComponentImport WhitelistService whitelistService, @ComponentImport OutboundWhitelist whitelist) {
        this.eventPublisher = eventPublisher;
        this.whitelistService = whitelistService;
        this.whitelist = whitelist;
    }

    public List<String> getRules() {
        if (this.isDisabled()) {
            return Collections.emptyList();
        }
        return this.getLegacyWhitelistRules();
    }

    public boolean isDisabled() {
        return !this.whitelistService.isWhitelistEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> updateRules(List<String> newRules, boolean disabled) {
        try {
            ImportUtils.setSubvertSecurityScheme((boolean)true);
            List<String> list = this.updateWhitelist(newRules, disabled);
            return list;
        }
        finally {
            ImportUtils.setSubvertSecurityScheme((boolean)false);
        }
    }

    private List<String> updateWhitelist(List<String> newRules, boolean disabled) {
        if (disabled) {
            this.whitelistService.disableWhitelist();
        } else {
            this.whitelistService.enableWhitelist();
        }
        for (WhitelistRule whitelistRule : this.whitelistService.getAll()) {
            Integer whitelistRuleId = whitelistRule.getId();
            if (whitelistRuleId == null || whitelistRule.getType() == WhitelistType.APPLICATION_LINK) continue;
            this.whitelistService.remove(whitelistRuleId.intValue());
        }
        for (String rule : newRules) {
            this.whitelistService.add((WhitelistRule)new LegacyWhitelistRule(rule));
        }
        return this.getRules();
    }

    public boolean isAllowed(URI uri) {
        return this.whitelist.isAllowed(uri);
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onAddGadget(AddGadgetEvent addGadgetEvent) {
        this.addWhitelistEntry(addGadgetEvent.getGadgetUri());
    }

    @EventListener
    public void onAddGadgetFeed(AddGadgetFeedEvent addGadgetFeedEvent) {
        this.addWhitelistEntry(addGadgetFeedEvent.getFeedUri());
    }

    private void addWhitelistEntry(URI uri) {
        if (!this.whitelist.isAllowed(uri)) {
            String newRule = uri.getScheme() + "://" + uri.getAuthority() + "/*";
            this.addWhitelistRule(newRule);
        }
    }

    private void addWhitelistRule(String newRule) {
        try {
            ImportUtils.setSubvertSecurityScheme((boolean)true);
            this.whitelistService.add((WhitelistRule)ImmutableWhitelistRule.builder().expression(newRule).type(WhitelistType.WILDCARD_EXPRESSION).build());
        }
        finally {
            ImportUtils.setSubvertSecurityScheme((boolean)false);
        }
    }

    private List<String> getLegacyWhitelistRules() {
        Iterable transformedList = Iterables.transform((Iterable)this.whitelistService.getAll(), this.toLegacyWhitelistRule());
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)transformedList, (Predicate)Predicates.notNull()));
    }

    private Function<WhitelistRule, String> toLegacyWhitelistRule() {
        return new Function<WhitelistRule, String>(){

            public String apply(WhitelistRule input) {
                if (input.getType() == WhitelistType.EXACT_URL) {
                    return "=" + input.getExpression();
                }
                if (input.getType() == WhitelistType.REGULAR_EXPRESSION) {
                    return "/" + input.getExpression();
                }
                if (input.getType() == WhitelistType.WILDCARD_EXPRESSION) {
                    return input.getExpression();
                }
                return null;
            }
        };
    }
}

