/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system.util;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.gadgets.system.StatsMarkup;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.statistics.util.FieldValueToDisplayTransformer;
import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatsMarkupFieldValueToDisplayTransformer
implements FieldValueToDisplayTransformer<StatsMarkup> {
    private final JiraAuthenticationContext authenticationContext;
    private final ConstantsManager constantsManager;
    private final CustomFieldManager customFieldManager;
    private final VelocityRequestContextFactory contextFactory;
    private final SoyTemplateRendererProvider soyTemplateRendererProvider;

    @Autowired
    public StatsMarkupFieldValueToDisplayTransformer(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport ConstantsManager constantsManager, @ComponentImport CustomFieldManager customFieldManager, @ComponentImport VelocityRequestContextFactory contextFactory, @ComponentImport SoyTemplateRendererProvider soyTemplateRendererProvider) {
        this.authenticationContext = authenticationContext;
        this.constantsManager = constantsManager;
        this.customFieldManager = customFieldManager;
        this.contextFactory = contextFactory;
        this.soyTemplateRendererProvider = soyTemplateRendererProvider;
    }

    public StatsMarkup transformFromIrrelevant(String fieldType, Object input, String url) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        String html = this.makeMarkupForCellWithHtmlSafeText(i18n.getText("common.concepts.irrelevant"), url);
        return new StatsMarkup(html);
    }

    public StatsMarkup transformFromProject(String fieldType, Object input, String url) {
        return this.generateProjectMarkup(input, url);
    }

    public StatsMarkup transformFromAssignee(String fieldType, Object input, String url) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        return this.generateAssigneesMarkup(input, url, i18n);
    }

    public StatsMarkup transformFromReporter(String fieldType, Object input, String url) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        return this.generateReporterMarkup(input, url, i18n);
    }

    public StatsMarkup transformFromCreator(String fieldType, Object input, String url) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        return this.generateCreatorMarkup(input, url, i18n);
    }

    public StatsMarkup transformFromResolution(String fieldType, Object input, String url) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        if (input == null) {
            String html = this.makeMarkupForCellWithHtmlSafeText(i18n.getText("common.resolution.unresolved"), url);
            return new StatsMarkup(html);
        }
        return this.generateConstantsMarkup(input, url);
    }

    public StatsMarkup transformFromPriority(String fieldType, Object input, String url) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        if (input == null) {
            String html = this.makeMarkupForCellWithHtmlSafeText(i18n.getText("gadget.filterstats.priority.nopriority"), url);
            return new StatsMarkup(html);
        }
        return this.generateConstantsMarkup(input, url);
    }

    public StatsMarkup transformFromIssueType(String fieldType, Object input, String url) {
        return this.generateConstantsMarkup(input, url);
    }

    public StatsMarkup transformFromStatus(String fieldType, Object input, String url) {
        return this.generateStatusMarkup(input, url);
    }

    public StatsMarkup transformFromComponent(String fieldType, Object input, String url) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        return this.generateComponentsMarkup(input, url, i18n);
    }

    public StatsMarkup transformFromVersion(String fieldType, Object input, String url) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        return this.generateVersionMarkup(input, url, i18n, "gadget.filterstats.raisedin.unscheduled");
    }

    public StatsMarkup transformFromFixFor(String fieldType, Object input, String url) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        return this.generateVersionMarkup(input, url, i18n, "gadget.filterstats.fixfor.unscheduled");
    }

    public StatsMarkup transformFromLabels(String fieldType, Object input, String url) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        if (input != null) {
            return new StatsMarkup(this.makeMarkupForCellWithHtmlUnsafeText(((Label)input).getLabel(), url));
        }
        return new StatsMarkup(this.makeMarkupForCellWithHtmlSafeText(i18n.getText("gadget.filterstats.labels.none"), url));
    }

    public StatsMarkup transformFromCustomField(String fieldType, Object input, String url) {
        CustomField customField;
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        if (input != null && (customField = this.customFieldManager.getCustomFieldObject(fieldType)) != null) {
            CustomFieldSearcher searcher = customField.getCustomFieldSearcher();
            CustomFieldSearcherModuleDescriptor moduleDescriptor = searcher.getDescriptor();
            return new StatsMarkup(moduleDescriptor.getStatHtml(customField, input, url));
        }
        String html = this.makeMarkupForCellWithHtmlSafeText(i18n.getText("common.words.none"), url);
        return new StatsMarkup(html);
    }

    private StatsMarkup generateVersionMarkup(Object input, String url, I18nHelper i18n, String noneKey) {
        if (input != null) {
            Version version = (Version)input;
            String html = this.makeMarkupForCellWithHtmlUnsafeDescriptionAndText(version.getName(), version.getDescription(), url);
            return new StatsMarkup(html, this.getVersionClasses(version));
        }
        String html = this.makeMarkupForCellWithHtmlSafeText(i18n.getText(noneKey), url);
        return new StatsMarkup(html);
    }

    private StatsMarkup generateComponentsMarkup(Object input, String url, I18nHelper i18n) {
        if (input != null) {
            String desc;
            String name;
            if (input instanceof ProjectComponent) {
                ProjectComponent component = (ProjectComponent)input;
                name = component.getName();
                desc = component.getDescription();
            } else {
                GenericValue gv = (GenericValue)input;
                name = gv.getString("name");
                desc = gv.getString("description");
            }
            String html = this.makeMarkupForCellWithHtmlUnsafeDescriptionAndText(name, desc, url);
            List classes = CollectionBuilder.list((Object[])new String[]{"default_image", "default_image_component"});
            return new StatsMarkup(html, classes);
        }
        String html = this.makeMarkupForCellWithHtmlSafeText(i18n.getText("gadget.filterstats.component.nocomponent"), url);
        return new StatsMarkup(html);
    }

    private StatsMarkup generateConstantsMarkup(Object input, String url) {
        IssueConstant constant = input instanceof GenericValue ? this.constantsManager.getIssueConstant((GenericValue)input) : (IssueConstant)input;
        String html = this.makeConstantMarkup(constant, url);
        List classes = CollectionBuilder.list((Object[])new String[]{"gadget_image"});
        return new StatsMarkup(html, classes);
    }

    private StatsMarkup generateStatusMarkup(Object input, String url) {
        String result;
        SoyTemplateRenderer renderer = this.soyTemplateRendererProvider.getRenderer();
        IssueConstant constant = input instanceof GenericValue ? this.constantsManager.getIssueConstant((GenericValue)input) : (IssueConstant)input;
        ImmutableMap.Builder params = ImmutableMap.builder();
        SimpleStatus simpleStatus = this.constantsManager.getStatusObject(constant.getId()).getSimpleStatus();
        params.put((Object)"issueStatus", (Object)simpleStatus);
        params.put((Object)"isSubtle", (Object)true);
        try {
            result = renderer.render("jira.webresources:issue-statuses", "JIRA.Template.Util.Issue.Status.issueStatusResolver", (Map)params.build());
        }
        catch (SoyException e) {
            throw new RuntimeException(e);
        }
        return new StatsMarkup(result);
    }

    private StatsMarkup generateReporterMarkup(Object input, String url, I18nHelper i18n) {
        String html;
        if (input != null) {
            ApplicationUser assignee = (ApplicationUser)input;
            html = this.makeMarkupForCellWithHtmlUnsafeText(assignee.getDisplayName(), url);
        } else {
            html = this.makeMarkupForCellWithHtmlSafeText(i18n.getText("common.concepts.no.reporter"), url);
        }
        return new StatsMarkup(html);
    }

    private StatsMarkup generateCreatorMarkup(Object input, String url, I18nHelper i18n) {
        String html;
        if (input != null) {
            ApplicationUser creator = (ApplicationUser)input;
            html = this.makeMarkupForCellWithHtmlUnsafeText(creator.getDisplayName(), url);
        } else {
            html = this.makeMarkupForCellWithHtmlSafeText(i18n.getText("common.concepts.anonymous.creator"), url);
        }
        return new StatsMarkup(html);
    }

    private StatsMarkup generateAssigneesMarkup(Object input, String url, I18nHelper i18n) {
        String html;
        if (input != null) {
            ApplicationUser assignee = (ApplicationUser)input;
            html = this.makeMarkupForCellWithHtmlUnsafeText(assignee.getDisplayName(), url);
        } else {
            html = this.makeMarkupForCellWithHtmlSafeText(i18n.getText("gadget.filterstats.assignee.unassigned"), url);
        }
        return new StatsMarkup(html);
    }

    private StatsMarkup generateProjectMarkup(Object input, String url) {
        String html;
        if (input instanceof GenericValue) {
            GenericValue project = (GenericValue)input;
            html = this.makeMarkupForCellWithHtmlUnsafeText(project.getString("name"), url);
        } else {
            Project project = (Project)input;
            html = this.makeMarkupForCellWithHtmlUnsafeText(project.getName(), url);
        }
        return new StatsMarkup(html);
    }

    private String makeConstantMarkup(IssueConstant constant, String url) {
        return this.makeConstantIconMarkup(constant) + this.makeMarkupForCellWithHtmlUnsafeDescriptionAndText(constant.getNameTranslation(), constant.getDescTranslation(), url);
    }

    private String makeConstantIconMarkup(IssueConstant constant) {
        String iconUrl = constant.getIconUrl();
        if (iconUrl != null && !"".equals(iconUrl)) {
            if (iconUrl.startsWith("http://") || iconUrl.startsWith("https://")) {
                return this.makeImageMarkup(constant, iconUrl);
            }
            VelocityRequestContext context = this.contextFactory.getJiraVelocityRequestContext();
            String baseUrl = context.getCanonicalBaseUrl();
            return this.makeImageMarkup(constant, baseUrl + iconUrl);
        }
        return "";
    }

    private String makeImageMarkup(IssueConstant constant, String url) {
        String name = TextUtils.htmlEncode((String)constant.getNameTranslation());
        String result = "<img src=\"" + url + "\" height=\"16\" width=\"16\" alt=\"" + name + "\" title=\"" + name + " - ";
        String descTranslation = constant.getDescTranslation() == null ? "" : constant.getDescTranslation();
        result = result + TextUtils.htmlEncode((String)descTranslation) + "\"/>";
        return result;
    }

    private String makeMarkupForCellWithHtmlSafeText(String htmlSafeLinkText, String url) {
        return StringUtils.isBlank((String)url) ? htmlSafeLinkText : "<a href='" + url + "'>" + htmlSafeLinkText + "</a>";
    }

    private String makeMarkupForCellWithHtmlUnsafeText(String linkTextToEncode, String url) {
        return this.makeMarkupForCellWithHtmlSafeText(TextUtils.htmlEncode((String)linkTextToEncode), url);
    }

    private String makeMarkupForCellWithHtmlUnsafeDescriptionAndText(String linkTextToEncode, String desc, String url) {
        if (StringUtils.isBlank((String)desc) || StringUtils.isBlank((String)url)) {
            return this.makeMarkupForCellWithHtmlUnsafeText(linkTextToEncode, url);
        }
        return "<a href='" + url + "' title='" + TextUtils.htmlEncode((String)desc) + "'>" + TextUtils.htmlEncode((String)linkTextToEncode) + "</a>";
    }

    private List<String> getVersionClasses(Version version) {
        ArrayList<String> classes = new ArrayList<String>();
        if (version.isArchived()) {
            classes.add("archived_version");
        }
        classes.add("default_image");
        if (version.isReleased() && !version.isArchived()) {
            classes.add("released_unarchived_version");
        } else if (version.isReleased() && version.isArchived()) {
            classes.add("released_archived_version");
        } else if (!version.isReleased() && !version.isArchived()) {
            classes.add("unreleased_unarchived_version");
        } else if (!version.isReleased() && version.isArchived()) {
            classes.add("unreleased_archived_version");
        }
        return classes;
    }
}

