/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.gadgets.system.util;

import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class ResourceDateValidator {
    private static String MAX_DAYS_AP_PREFIX = "jira.chart.days.previous.limit.";
    private static final int INVALID_DAYS = -1;
    private final ApplicationProperties applicationProperties;

    public ResourceDateValidator(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public int validateDaysPrevious(String fieldName, ChartFactory.PeriodName period, String days, Collection<ValidationError> errors) {
        int numberOfDays;
        try {
            numberOfDays = Integer.valueOf(days);
            if (numberOfDays < 0) {
                errors.add(new ValidationError(fieldName, "gadget.common.negative.days"));
            }
        }
        catch (NumberFormatException e) {
            errors.add(new ValidationError(fieldName, "gadget.common.days.nan"));
            return -1;
        }
        if (numberOfDays >= 0 && period != null) {
            this.validateDaysAgainstPeriod(fieldName, period, numberOfDays, errors);
        }
        return numberOfDays;
    }

    public ChartFactory.PeriodName validatePeriod(String fieldName, String periodName, Collection<ValidationError> errors) {
        try {
            return ChartFactory.PeriodName.valueOf((String)periodName);
        }
        catch (IllegalArgumentException e) {
            errors.add(new ValidationError(fieldName, "gadget.common.invalid.period"));
            return null;
        }
    }

    void validateDaysAgainstPeriod(String fieldName, ChartFactory.PeriodName period, int days, Collection<ValidationError> errors) {
        Integer limitForPeriod;
        String maxDaysPropertyKey = MAX_DAYS_AP_PREFIX + period.toString();
        String maxDaysValue = this.applicationProperties.getDefaultBackedString(maxDaysPropertyKey);
        if (StringUtils.isBlank((String)maxDaysValue)) {
            switch (period) {
                case hourly: {
                    maxDaysValue = "10";
                    break;
                }
                case daily: {
                    maxDaysValue = "300";
                    break;
                }
                case weekly: {
                    maxDaysValue = "1750";
                    break;
                }
                case monthly: {
                    maxDaysValue = "7500";
                    break;
                }
                case quarterly: {
                    maxDaysValue = "22500";
                    break;
                }
                case yearly: {
                    maxDaysValue = "36500";
                    break;
                }
                default: {
                    maxDaysValue = "300";
                }
            }
        }
        if ((limitForPeriod = Integer.valueOf(maxDaysValue)) < days) {
            errors.add(new ValidationError(fieldName, "gadget.common.days.overlimit.for.period", Arrays.asList(limitForPeriod.toString(), period.toString())));
        }
    }
}

